<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include("../config.php");

if (!isset($conn) || !$conn) {
    die("❌ Database connection failed. Please check config.php credentials or path.");
}

$result = null;
$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $certificate_no = trim($_POST['certificate_no']);
    if (!empty($certificate_no)) {
        $query = "
        SELECT 
            ic.certificate_no,
            ic.issue_date,
            ic.status AS certificate_status,
            s.name AS student_name,
            c.name AS course_name,
            b.title AS batch_title,
            e.enrolment_date
        FROM issue_certificate ic
        LEFT JOIN student s ON ic.mobile = s.mobile
        LEFT JOIN course c ON ic.cid = c.id
        LEFT JOIN batch b ON ic.bid = b.id
        LEFT JOIN enrolments e ON ic.mobile = e.mobile
        WHERE ic.certificate_no = ?
        ";
        $stmt = $conn->prepare($query);
        if (!$stmt) die("❌ SQL Prepare failed: " . $conn->error);
        $stmt->bind_param("s", $certificate_no);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($res === false) die("❌ Query Execution failed: " . $stmt->error);
        $result = $res->fetch_assoc();
        if (!$result) $error = "Certificate not found. Please check the number and try again.";
    } else {
        $error = "Please enter a certificate number.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Verify Certificate | Eshua EdTech</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Bootstrap & Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background: #f4f6f8;
      font-family: 'Poppins', sans-serif;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
    }
    .verify-box {
      background: #fff;
      border-radius: 20px;
      box-shadow: 0 10px 40px rgba(0,0,0,0.1);
      padding: 40px 35px;
      width: 100%;
      max-width: 520px;
      text-align: center;
    }
    .verify-header {
      display: flex;
      flex-direction: column;
      align-items: center;
      margin-bottom: 25px;
    }
    .verify-header .icon {
      background: linear-gradient(135deg, #007bff, #00c6ff);
      color: white;
      font-size: 45px;
      border-radius: 50%;
      padding: 15px;
      margin-bottom: 10px;
    }
    .verify-header h2 {
      font-weight: 700;
      color: #1f2d3d;
      font-size: 1.6rem;
      margin-bottom: 5px;
    }
    .verify-header p {
      color: #6c757d;
      font-size: 0.9rem;
    }
    .form-control {
      border-radius: 10px;
      padding: 12px;
      font-size: 1rem;
      border: 1px solid #dee2e6;
    }
    .btn-verify {
      background: linear-gradient(135deg, #007bff, #00c6ff);
      color: #fff;
      border: none;
      padding: 10px 30px;
      border-radius: 10px;
      font-weight: 600;
      transition: 0.3s;
      margin-top: 10px;
    }
    .btn-verify:hover {
      transform: scale(1.05);
      box-shadow: 0 5px 15px rgba(0,123,255,0.3);
    }
    .card-result {
      background: #f8f9fa;
      border-left: 5px solid #28a745;
      border-radius: 10px;
      padding: 20px;
      text-align: left;
      margin-top: 30px;
      animation: fadeIn 0.6s ease;
    }
    .card-result h4 {
      color: #28a745;
      font-weight: 700;
      margin-bottom: 15px;
    }
    .card-result p {
      color: #343a40;
      margin-bottom: 5px;
    }
    .alert {
      border-radius: 10px;
      margin-top: 20px;
    }
    footer {
      text-align: center;
      margin-top: 40px;
      font-size: 0.85rem;
      color: #6c757d;
    }
    @keyframes fadeIn {
      from {opacity: 0; transform: translateY(15px);}
      to {opacity: 1; transform: translateY(0);}
    }
  </style>
</head>
<body>

<div class="verify-box">
  <div class="verify-header">
    <div class="icon"><i class="bi bi-patch-check-fill"></i></div>
    <h2>Certificate Verification</h2>
    <p>Enter your certificate number to confirm authenticity.</p>
  </div>

  <form method="POST">
    <input type="text" name="certificate_no" class="form-control mb-3" placeholder="Enter Certificate Number" required>
    <button type="submit" class="btn btn-verify"><i class="bi bi-search"></i> Verify Now</button>
  </form>

  <?php if ($error): ?>
    <div class="alert alert-danger mt-3"><i class="bi bi-exclamation-circle"></i> <?= htmlspecialchars($error) ?></div>
  <?php endif; ?>

  <?php if ($result): ?>
  <div class="card-result">
    <h4><i class="bi bi-check-circle-fill"></i> Certificate Verified</h4>
    <p><strong>Certificate No:</strong> <?= htmlspecialchars($result['certificate_no']) ?></p>
    <p><strong>Name:</strong> <?= htmlspecialchars($result['student_name']) ?></p>
    <p><strong>Course:</strong> <?= htmlspecialchars($result['course_name']) ?></p>
    <p><strong>Batch:</strong> <?= htmlspecialchars($result['batch_title']) ?></p>
    <p><strong>Date of Enrollment:</strong> <?= htmlspecialchars($result['enrolment_date']) ?></p>
    <p><strong>Issue Date:</strong> <?= htmlspecialchars($result['issue_date']) ?></p>
    <p><strong>Status:</strong> <?= htmlspecialchars($result['certificate_status']) ?></p>
  </div>
  <?php endif; ?>

  <footer>© <?= date('Y') ?> Eshua EdTech | Certificate Authentication Portal</footer>
</div>

</body>
</html>
