<?php
include_once('./config.php');
header('Content-Type: application/json');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$data = json_decode(file_get_contents("php://input"), true);
$batch_id = $conn->real_escape_string($data['batch_id']);
$reg_mobile = $conn->real_escape_string($data['reg_mobile']);

if (empty($batch_id) || empty($reg_mobile)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required inputs.']);
    exit;
}

/* -------------------------------
   Determine if input is reg_no or mobile
--------------------------------*/
if (preg_match('/^IKP\d+$/i', $reg_mobile)) {
    // Search by registration number
    $studentQ = $conn->query("
        SELECT * FROM student 
        WHERE registration_no='$reg_mobile' 
        AND status='Active' 
        AND deleted_at IS NULL
        LIMIT 1
    ");
} else {
    // Search by mobile
    $studentQ = $conn->query("
        SELECT * FROM student 
        WHERE mobile='$reg_mobile' 
        AND status='Active' 
        AND deleted_at IS NULL
        LIMIT 1
    ");
}

$student = $studentQ->fetch_assoc();

if (!$student) {
    echo json_encode(['status' => 'error', 'message' => 'No active student found with that registration number or mobile.']);
    exit;
}

$mobile = $student['mobile'];

/* -------------------------------
   Find enrollment
--------------------------------*/
$enrolmentQ = $conn->query("
    SELECT * FROM enrolments 
    WHERE bid='$batch_id' 
    AND mobile='$mobile' 
    AND deleted_at IS NULL
    LIMIT 1
");

$enrolment = $enrolmentQ->fetch_assoc();

if (!$enrolment) {
    echo json_encode(['status' => 'error', 'message' => 'No active enrollment found for the given batch and student.']);
    exit;
}

/* -------------------------------
   Get Course and Batch info
--------------------------------*/
$courseQ = $conn->query("
    SELECT * FROM course 
    WHERE id='".$enrolment['cid']."' 
    AND status='Active' 
    AND deleted_at IS NULL
    LIMIT 1
");
$course = $courseQ->fetch_assoc();

$batchQ = $conn->query("
    SELECT * FROM batch 
    WHERE id='".$enrolment['bid']."' 
    AND status='Active' 
    AND deleted_at IS NULL
    LIMIT 1
");
$batch = $batchQ->fetch_assoc();

/* -------------------------------
   Get Fee Receipts
--------------------------------*/
$paymentsRes = $conn->query("
    SELECT * FROM fees_receipts 
    WHERE enrolment_id='".$enrolment['enrolment_id']."' 
    AND status='Active' 
    AND deleted_at IS NULL
    ORDER BY payment_date ASC
");

$payments = [];
$total_paid = 0;

while ($p = $paymentsRes->fetch_assoc()) {
    // Include all payments in display
    $payments[] = [
        'payment_date' => date('d M Y', strtotime($p['payment_date'])),
        'payment_mode' => $p['payment_mode']." (".$p['payment_source'].")",
        'payment_amount' => $p['payment_amount'],
        'payment_status' => $p['payment_status']
    ];

    // count only paid or pending amounts
    if (strtolower($p['payment_status']) != 'failed') {
        $total_paid += $p['payment_amount'];
    }
}

/* -------------------------------
   Calculate Remaining Balance
--------------------------------*/
$course_total = ($course['fees'] - $course['discount']);
$remaining = max(0, $course_total - $total_paid);

/* -------------------------------
   Send JSON Response
--------------------------------*/
echo json_encode([
    'status' => 'success',
    'enrolment_id' => $enrolment['enrolment_id'],
    'course_id' => $enrolment['cid'],
    'batch_id' => $enrolment['bid'],
    'student_mobile' => $student['mobile'],
    'student_name' => $student['name'],
    'course_name' => $course['name'],
    'batch_title' => $batch['title'],
    'course_fees' => $course_total,
    'fee_status' => $enrolment['fee_status'],
    'remaining' => $remaining,
    'payments' => $payments
]);
?>
