<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include_once "./config.php";
ob_clean();
require("razorpay/Razorpay.php");
use Razorpay\Api\Api;

if (session_status() === PHP_SESSION_NONE) session_start();

require './office-login/PHPMailer/PHPMailer.php';
require './office-login/PHPMailer/SMTP.php';
require './office-login/PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// -------------------------------------------------------
// SEND SUBSCRIPTION SUCCESS MAIL
// -------------------------------------------------------
function sendSubscriptionSuccessMail($to, $name, $plan, $amount, $expiry) {
    global $conn;

    // Fetch SMTP settings
    $set = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM settings LIMIT 1"));

    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host     = $set['smtp_host'];
        $mail->SMTPAuth = true;

        // Brevo fallback
        if (
            strtolower(trim($set['smtp_host'])) === 'smtp-relay.brevo.com' &&
            (empty(trim($set['username'])) || empty(trim($set['password'])))
        ) {
            $mail->Username = getenv('SMTP_USER');
            $mail->Password = getenv('SMTP_PASS');
        } else {
            $mail->Username = $set['username'];
            $mail->Password = $set['password'];
        }

        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = $set['port_number'];

        // Sender
        $mail->setFrom($set['sender_email'], $set['display_name_email']);
        $mail->addAddress($to);

        $institute = $set['site_name'];

        // Prepare HTML body
        $mail->isHTML(true);
        $mail->Subject = "🎉 Subscription Activated – Enjoy Student Corner Premium!";

        $mail->Body = "
            <h2>Hello <strong>$name</strong> 👋</h2>

            <p>Thank you for subscribing to <strong>$institute Student Corner Premium</strong>!</p>

            <p>Your subscription is now active.</p>

            <h3>📌 Subscription Details</h3>
            <p><strong>Plan:</strong> $plan<br>
               <strong>Amount:</strong> ₹$amount<br>
               <strong>Valid Till:</strong> $expiry</p>

            <h3>🎓 Your Premium Benefits</h3>
            <ul>
                <li>📘 All Study Materials</li>
                <li>📝 Premium Notes</li>
                <li>📄 Model Answer Keys</li>
                <li>📚 Previous Year Papers</li>
                <li>📥 Unlimited Downloads</li>
                <li>⭐ Career & Exam Guidance</li>
                <li>🔥 All Exclusive Student Corner Resources</li>
                <li>And More..</li>
            </ul>

            <p>We hope you enjoy your premium learning experience!</p>

            <br>
            <p>Regards,<br><strong>$institute</strong></p>
        ";

        return $mail->send();

    } catch (Exception $e) {
        error_log("Subscription Email Error: " . $mail->ErrorInfo);
        return false;
    }
}



$data = json_decode(file_get_contents("php://input"), true);

$payment_id = $data['razorpay_payment_id'];
$order_id   = $data['razorpay_order_id'];
$signature  = $data['razorpay_signature'];

if (!$payment_id || !$order_id || !$signature) {
    echo json_encode(['status' => 'error', 'msg' => 'Missing required fields']);
    exit;
}

$settings = $conn->query("SELECT * FROM settings LIMIT 1")->fetch_assoc();
$keyId     = $settings['api_id'];
$keySecret = $settings['secret_key'];

try {
    $api = new Api($keyId, $keySecret);

    // Verify signature
    $attributes = [
        'razorpay_payment_id' => $payment_id,
        'razorpay_order_id' => $order_id,
        'razorpay_signature' => $signature
    ];

    $api->utility->verifyPaymentSignature($attributes);

    // HANDLE SUBSCRIPTION
    $mobile_no = $_SESSION['subscriber_mobile_no'];

    $amount = floatval($settings['subscription_amount']);
    $sub_date = date("Y-m-d");

    // VALIDITY FIX ✅
    $validity_text = $settings['subscription_validity'];
    $type = $validity_text;

    if (stripos($validity_text, "month") !== false) {
        preg_match('/(\d+)/', $validity_text, $m);
        $sub_expiry = date("Y-m-d", strtotime("+".$m[1]." months"));
    }
    else if (stripos($validity_text, "year") !== false) {
        preg_match('/(\d+)/', $validity_text, $m);
        $sub_expiry = date("Y-m-d", strtotime("+".$m[1]." years"));
    }
    else {
        preg_match('/(\d+)/', $validity_text, $m);
        $sub_expiry = date("Y-m-d", strtotime("+".$m[1]." days"));
    }

    $stmt = $conn->prepare("INSERT INTO subscriptions (mobile_no, type, sub_date, sub_expiry, amount)
                            VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssd", $mobile_no, $type, $sub_date, $sub_expiry, $amount);
    $stmt->execute();

    $conn->query("UPDATE subscriber SET status='subscribed' WHERE mobile_no='$mobile_no'");
    $_SESSION['subscriber_status'] = 'subscribed';
    
// Fetch subscriber email + name
$getMail = $conn->query("SELECT name, email FROM subscriber WHERE mobile_no='$mobile_no'");
$subUser = $getMail->fetch_assoc();

$subEmail = $subUser['email'];
$subName  = $subUser['name'];

// Send subscription success mail
sendSubscriptionSuccessMail($subEmail, $subName, $type, $amount, $sub_expiry);



    echo json_encode(['status' => 'success']);
    exit;


} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'msg' => $e->getMessage()]);
}




