<?php
session_start();
include "config.php";

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) die("Invalid video request");

// Fetch video info
$stmt = $conn->prepare("SELECT title, link, restriction FROM student_corner WHERE id=? AND status='Active'");
$stmt->bind_param("i", $id);
$stmt->execute();
$video = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$video) die("Video not found.");

$loggedIn = isset($_SESSION['subscriber_id']);
$subscribed = ($loggedIn && ($_SESSION['subscriber_status'] ?? '') === 'subscribed');

// Restriction check
if ($video['restriction'] === 'Restricted') {
    if (!$loggedIn) {
        header("Location: login.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }
    if (!$subscribed) {
        header("Location: subscription.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }
}

// ✅ ACTIVITY LOG
if ($loggedIn) {
    $mobile = $_SESSION['subscriber_mobile_no'] ?? '';
    $title = $conn->real_escape_string($video['title']);
    mysqli_query(
        $conn,
        "INSERT INTO activity_log (mobile_no, activity, created_at)
         VALUES ('$mobile', 'Watched Video: $title', NOW())"
    );
}

// ✅ Convert to YouTube embed (if needed)
$link = $video['link'];
if (preg_match('/(youtube\.com\/watch\?v=|youtu\.be\/)([A-Za-z0-9_-]+)/', $link, $match)) {
    $embed = "https://www.youtube.com/embed/" . $match[2];
} else {
    $embed = $link;
}
?>
<!DOCTYPE html>
<html>
<head>
<title><?php echo htmlspecialchars($video['title']); ?></title>
<style>
body { margin:0; padding:0; background:#000; }
iframe { width:100%; height:100vh; border:0; }
</style>
</head>
<body>
<iframe src="<?php echo $embed; ?>" allowfullscreen></iframe>
</body>
</html>
