<?php  include ("auth.php");
include ("../config.php");
// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Batches - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">


</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Batches</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Batches</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
            
     
          <a href="batch.php" class="btn btn-primary btn-sm"><i class="bi bi-plus"></i> Add New</a>

          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Batch List</h5>
              
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
              <!-- Table with stripped rows -->
              <div class="table-responsive">
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Action</th>
                    <th>Course</th>                    
                    <th>Batch</th>
                    <th>Details</th>
                    <th>Mode</th>
                    <th>Trainer</th>
                    <th data-type="date" data-format="YYYY/DD/MM" style="white-space: nowrap;">Last Updated</th>
                    
                  </tr>
                </thead>
<tbody>
<?php
$sql = "SELECT b.*,c.name as course FROM `batch` b inner join course c on b.cid=c.id WHERE b.deleted_at is NULL order by b.id desc";
$result = mysqli_query($conn, $sql);
$sl=1;
if ($result && mysqli_num_rows($result) > 0) {
  while ($row = mysqli_fetch_assoc($result)) {
    echo "<tr>";
    echo "<td style='white-space: nowrap;'>".$sl."</td>";
    echo "<td style='white-space: nowrap;'>
        <a href='batch.php?id=" . base64_encode($row['id']) . "' class='btn btn-sm btn-warning'>
          <i class='bi bi-pen'></i>
        </a>
        <button class='btn btn-sm btn-danger' onclick='deleteBatch(" . $row['id'] . ")'>
          <i class='bi bi-trash'></i>
        </button>";
        
        if ($row['status'] === 'Active') {
        echo " <a href='enrolement.php?batch=" . base64_encode($row['id']) . "' class='btn btn-sm btn-success'>Enroll</a>";
        }
      if ($row['status'] === 'Active') {
    echo " <button class='btn btn-sm btn-success' onclick='toggleBatchStatus(" . $row['id'] . ", \"Deactivate\")'>
             Deactivate
          </button>";
} else {
    echo " <button class='btn btn-sm btn-danger' onclick='toggleBatchStatus(" . $row['id'] . ", \"Activate\")'>
            Activate
          </button>";
}  
        
        
    echo    "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['course']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['title']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['details']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['mode']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['trainer']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['updated_at']) . "</td>";
    
    echo "</tr>";
    $sl++;
  }
} else {
  echo "<tr><td colspan='8' class='text-center'>No batch found.</td></tr>";
}
?>
</tbody>

              </table>
              </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/batch.js"></script>

</body>

</html>