<?php  
include ("auth.php");
include ("../config.php");
include ("./DashboardData.php");

// Use separate filters for each card
$enqFilter = isset($_GET['enq_filter']) ? strtolower($_GET['enq_filter']) : 'today';
$followupFilter = isset($_GET['followup_filter']) ? strtolower($_GET['followup_filter']) : 'today';

$allowedFilters = ['today', 'week', 'month'];
if (!in_array($enqFilter, $allowedFilters)) $enqFilter = 'today';
if (!in_array($followupFilter, $allowedFilters)) $followupFilter = 'today';

$dashboard = new DashboardData($conn);

// Fetch counts independently
$enquiryCount = $dashboard->getCount('enquiries', $enqFilter);
$followupCount = $dashboard->getCount('followups', $followupFilter);

// Quick counts for dashboard
$courseCount = $dashboard->getCount('course', 'all');
$batchCount = $dashboard->getCount('batch', 'all');
$studentCount = $dashboard->getCount('student', 'all');
$enrolmentCount = $dashboard->getCount('enrolments', 'all');
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Dashboard - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

  
</head>

<body>

  <!-- ======= Header ======= -->
<?php  include ("./templates/header.php"); ?>

  <!-- ======= Sidebar ======= -->
<?php  include ("./templates/sidebar.php"); ?>

  <main id="main" class="main">

    <!--<div class="pagetitle">-->
    <!--  <h1>Dashboard</h1>-->
    <!--  <nav>-->
    <!--    <ol class="breadcrumb">-->
    <!--      <li class="breadcrumb-item"><a href="index.html">Home</a></li>-->
    <!--      <li class="breadcrumb-item active">Dashboard</li>-->
    <!--    </ol>-->
    <!--  </nav>-->
    <!--</div><!-- End Page Title -->

    <section class="section dashboard">
      <div class="row">

        <!-- Left side columns -->
        <div class="col-lg-12">
          <div class="row">

            <!-- Sales Card -->
            <div class="col-xxl-6 col-md-6">
              <div class="card info-card sales-card">

                <div class="filter">
                  <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
                  <!-- Filters for Enquiries -->
                   <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                     <li class="dropdown-header text-start"><h6>Filter</h6></li>
                     <li><a class="dropdown-item" href="?enq_filter=today&followup_filter=<?= $followupFilter ?>">Today</a></li>
                     <li><a class="dropdown-item" href="?enq_filter=week&followup_filter=<?= $followupFilter ?>">This Week</a></li>
                     <li><a class="dropdown-item" href="?enq_filter=month&followup_filter=<?= $followupFilter ?>">This Month</a></li>
                   </ul>
                </div>

                <div class="card-body bg-primary">
                  <h5 class="card-title  text-white">Enquiries <span class="text-white">| <?= ucfirst($enqFilter) ?></span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-phone-vibrate"></i>
                    </div>
                    <div class="ps-3">
                      <h6 class="text-white"><?= $enquiryCount ?></h6>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Sales Card -->

            <!-- Revenue Card -->
            <div class="col-xxl-6 col-md-6">
              <div class="card info-card sales-card">

                <div class="filter">
                  <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
                  <!-- Filters for Follow Ups -->
                   <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                     <li class="dropdown-header text-start"><h6>Filter</h6></li>
                     <li><a class="dropdown-item" href="?enq_filter=<?= $enqFilter ?>&followup_filter=today">Today</a></li>
                     <li><a class="dropdown-item" href="?enq_filter=<?= $enqFilter ?>&followup_filter=week">This Week</a></li>
                     <li><a class="dropdown-item" href="?enq_filter=<?= $enqFilter ?>&followup_filter=month">This Month</a></li>
                   </ul>
                </div>

                <div class="card-body bg-warning">
                  <h5 class="card-title text-white">Follow Ups <span class="text-white">| <?= ucfirst($followupFilter) ?></span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-up"></i>
                    </div>
                    <div class="ps-3">
                      <h6 class="text-white"><?= $followupCount ?></h6>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Revenue Card -->

          </div>
        </div><!-- End Left side columns -->
      </div>
      
      <div class="row">

  <!-- Courses Card -->
  <div class="col-xxl-3 col-md-3">
    <div class="card info-card sales-card">
      <div class="card-body">
        <h5 class="card-title">Courses</h5>
        <div class="d-flex align-items-center">
          <div class="card-icon rounded-circle d-flex align-items-center justify-content-center bg-primary">
            <i class="bi bi-journal-bookmark-fill text-white"></i>
          </div>
          <div class="ps-3">
            <h6><?= $courseCount ?></h6>
            <a href="courses.php" class="small">Manage<br>Courses</a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Batches Card -->
  <div class="col-xxl-3 col-md-3">
    <div class="card info-card sales-card">
      <div class="card-body">
        <h5 class="card-title">Batches</h5>
        <div class="d-flex align-items-center">
          <div class="card-icon rounded-circle d-flex align-items-center justify-content-center bg-success">
            <i class="bi bi-people-fill text-white"></i>
          </div>
          <div class="ps-3">
            <h6><?= $batchCount ?></h6>
            <a href="batches.php" class="small">Manage<br>Batches</a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Students Card -->
  <div class="col-xxl-3 col-md-3">
    <div class="card info-card sales-card">
      <div class="card-body">
        <h5 class="card-title">Students</h5>
        <div class="d-flex align-items-center">
          <div class="card-icon rounded-circle d-flex align-items-center justify-content-center bg-warning">
            <i class="bi bi-person-fill text-white"></i>
          </div>
          <div class="ps-3">
            <h6><?= $studentCount ?></h6>
            <a href="students.php" class="small">Manage<br>Students</a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Enrollments Card -->
  <div class="col-xxl-3 col-md-3">
    <div class="card info-card sales-card">
      <div class="card-body">
        <h5 class="card-title">Enrolments</h5>
        <div class="d-flex align-items-center">
          <div class="card-icon rounded-circle d-flex align-items-center justify-content-center bg-danger">
            <i class="bi bi-journal-check text-white"></i>
          </div>
          <div class="ps-3">
            <h6><?= $enrolmentCount ?></h6>
            <a href="enrolements.php" class="small">Manage<br>Enrolments</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Quick Actions Row -->
<div class="row mt-3">
  <!-- Enroll Student -->
  <div class="col-xxl-4 col-md-4">
    <a href="enrolement.php" class="text-decoration-none">
      <div class="card bg-primary text-white">
        <div class="card-body d-flex align-items-center">
          <i class="bi bi-person-plus-fill fs-1 me-3"></i>
          <span class="fs-5">Enroll Student</span>
        </div>
      </div>
    </a>
  </div>

  <!-- Add Fees -->
  <div class="col-xxl-4 col-md-4">
    <a href="fee.php" class="text-decoration-none">
      <div class="card bg-success text-white">
        <div class="card-body d-flex align-items-center">
          <i class="bi bi-cash-stack fs-1 me-3"></i>
          <span class="fs-5">Add Fees</span>
        </div>
      </div>
    </a>
  </div>

  <!-- Mark Attendance -->
  <div class="col-xxl-4 col-md-4 mt-2 mt-md-0">
    <a href="attendance.php" class="text-decoration-none">
      <div class="card bg-warning text-white">
        <div class="card-body d-flex align-items-center">
          <i class="bi bi-calendar-check fs-1 me-3"></i>
          <span class="fs-5">Mark Attendance</span>
        </div>
      </div>
    </a>
  </div>
  
</div>
    </section>

  </main><!-- End #main -->
<br><br><br><br><br><br><br><br><br><br><br>
  <!-- ======= Footer ======= -->
<?php  include ("./templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>

</body>

</html>