<?php  include ("auth.php");
include ("../config.php");
function getUserNameById($userId, $conn) {
    // Sanitize input to prevent SQL injection
    $userId = (int) $userId;

    // Prepare the SQL statement to retrieve the user's name based on the ID
    $stmt = $conn->prepare("SELECT name FROM users WHERE user_id = ?");
    
    // Bind the user_id parameter
    $stmt->bind_param("i", $userId);

    // Execute the query
    $stmt->execute();

    // Bind the result variable to fetch the name
    $stmt->bind_result($userName);

    // Fetch the result
    if ($stmt->fetch()) {
        // Return the user's name
        return $userName;
    } else {
        // If no user found, return null or an error message
        return null;
    }

    // Close the statement
    $stmt->close();
}
function getnextdate($enquiryId, $conn) {
    // Sanitize input to prevent SQL injection
    $enquiryId = (int) $enquiryId;

    // Prepare the SQL statement to retrieve the user's name based on the ID
    $stmt = $conn->prepare("SELECT next_action_date FROM followups WHERE enquiry_id = ? AND deleted_at is NULL order by followup_id Desc LIMIT 1");
    
    $stmt->bind_param("i", $enquiryId);

    $stmt->execute();
    $stmt->bind_result($nextdate);

    // Fetch the result
    if ($stmt->fetch()) {
        if($nextdate!=='0000-00-00')
        return date('d-m-Y',strtotime($nextdate));
        else 
        return 'NA';
    } else {
        return 'NA';
    }

    // Close the statement
    $stmt->close();
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Enquiries - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
<style>
    .form-select {
    min-width: 150px; /* Adjust the value as needed */
    width: auto; /* Let the width adjust based on the content */
    white-space: nowrap; /* Prevent text from breaking into multiple lines */
}

</style>
<script>
  // Wait for the DOM to be ready
  document.addEventListener('DOMContentLoaded', function () {
    // Get all "Follow Up" buttons
    const followUpButtons = document.querySelectorAll('.follow-up-btn');

    // Loop through each button and add an event listener
    followUpButtons.forEach(button => {
      button.addEventListener('click', function () {
        // Get the enquiry_id from the button's data-enquiry-id attribute
        const enquiryId = this.getAttribute('data-enquiry-id');

        // Set the value of the hidden input field in the modal
        document.getElementById('enquiry_id').value = enquiryId;
      });
    });
  });
</script>

</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Enquiries</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Enquiries</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
            
 
          <a href="enquiry.php" class="btn btn-primary btn-sm"><i class="bi bi-plus"></i> Add New</a>
     
          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Enquiry List</h5>
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
              <!-- Table with stripped rows -->
              <div class="table-responsive">
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Action</th>
                    <th>User</th>
                    <th>Subject</th>
                    <th>Message</th>
                    <th>Source</th>
                    <th>Reference</th>
                    <th style='white-space: nowrap;'>Assigned To</th>
                    <th data-type="date" data-format="YYYY/DD/MM" style="white-space: nowrap;">Enquiry Date</th>
                    <th data-type="date" data-format="YYYY/DD/MM" style="white-space: nowrap;">Next Enquiry Date</th>
                    <th>Status</th>
                  </tr>
                </thead>
<tbody>
<?php
// SQL query to get users (excluding Admin role)
$sql_users = "SELECT user_id, name FROM users WHERE role != 'Admin'";
$result_users = mysqli_query($conn, $sql_users);

// SQL query to get enquiries
$sql = "SELECT e.*, s.subjects, r.reference_title 
        FROM `enquiries` e
        LEFT JOIN `enquiries_subjects` s ON e.subject = s.id
        LEFT JOIN `enquiries_references` r ON e.reference = r.id
        WHERE e.deleted_at IS NULL
        ORDER BY e.enquiry_id DESC";

$result = mysqli_query($conn, $sql);
$sl = 1;

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
         
    $status = $row['status'];
    // Initialize background color based on the status
    $bg_color = ''; // No background color for "New Enquiry"
    if ($status == 'Closed') {
        $bg_color = 'background-color: #e6bab7'; // Light Red for "Closed"
    } elseif ($status == 'In Follow Up') {
        $bg_color = 'background-color: #efec9f'; // Light Yellow for "In Follow Up"
    }
    
    // Output each row
        echo "<tr style=''>";
        echo "<td style='white-space: nowrap;".$bg_color."'>" . $sl . "</td>";
                echo "<td style='white-space: nowrap;".$bg_color."'>
                <button class='btn btn-sm btn-info follow-up-btn' data-bs-toggle='modal' data-bs-target='#followUpModal' data-enquiry-id='".$row['enquiry_id']."'>Follow Up</button>
                <button class='btn btn-sm btn-success follow-up-history' data-bs-toggle='modal' data-bs-target='#followUpHistoryModal' data-enquiry-id='".$row['enquiry_id']."' data-enquiry-name='".htmlspecialchars($row['name'], ENT_QUOTES)."'>History</button>
                <a href='enquiry.php?id=" . base64_encode($row['enquiry_id']) . "' class='btn btn-sm btn-warning'><i class='bi bi-pen'></i></a>
                <button class='btn btn-sm btn-danger' onclick='deleteEnquiry(".$row['enquiry_id'].")'>
                 <i class='bi bi-trash'></i>
                </button>
              </td>";
        echo "<td style='white-space: nowrap;".$bg_color."'>" . htmlspecialchars($row['name']) . "<br>". htmlspecialchars($row['email']) ."<br>". htmlspecialchars($row['phone']) ."</td>";
        echo "<td style='white-space: nowrap;".$bg_color."'>" . htmlspecialchars($row['subjects']) . "</td>";
        echo "<td style='white-space: nowrap;".$bg_color."'>" . htmlspecialchars($row['message']) . "</td>";
        echo "<td style='white-space: nowrap;".$bg_color."'>" . htmlspecialchars($row['source']) . "</td>";
        echo "<td style='white-space: nowrap;".$bg_color."'>" . htmlspecialchars($row['reference_title']) . "</td>";
echo "<td style='".$bg_color."'>";

// Always show the select dropdown for assigning the executive
echo "<select class='form-select assign-executive' data-enquiry-id='" . $row['enquiry_id'] . "'>";
echo "<option style='background-color:#dfe0e1;' value=''>Assign Executive</option>";

// Check if the enquiry is already assigned
$assigned_to = $row['assigned_to'] ?? '';
if ($assigned_to) {
    // If already assigned, show the name of the executive as the selected option
    $assigned_name = getUserNameById($assigned_to, $conn);
    echo "<option value='" . $assigned_to . "' selected>" . htmlspecialchars($assigned_name) . "</option>";
}

// Loop through the users and create options for unassigned
// Get users from the result or another query if needed
while ($user = mysqli_fetch_assoc($result_users)) {
    // Ensure we don't add the assigned user again in the dropdown
    if ($user['user_id'] != $assigned_to) {
        echo "<option value='" . $user['user_id'] . "'>" . htmlspecialchars($user['name']) . "</option>";
    }
}

echo "</select>";

echo "</td>";
        
        echo "<td style='white-space: nowrap;".$bg_color."'>" . date('d-m-Y', strtotime($row['created_at'])) . "</td>";
        echo "<td style='white-space: nowrap;".$bg_color."'>" . getnextdate($row['enquiry_id'],$conn) . "</td>";
        echo "<td style='white-space: nowrap;".$bg_color."'>" . $row['status'] . "</td>";

        $sl++;
    }
} else {
    echo "<tr><td colspan='11' class='text-center'>No Enquiry found.</td></tr>";
}
?>
</tbody>

              </table>
              </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->


  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<!-- Follow Up Modal -->
<div class="modal fade" id="followUpModal" tabindex="-1" aria-labelledby="followUpModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="followUpModalLabel">Follow Up</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="followUpForm" method="POST" action="submit_followup.php">
           <!-- Predefined fields (e.g., enquiry_id, user_id) -->
          <input type="hidden" id="enquiry_id" name="enquiry_id" >
          <input type="hidden" id="csrftoken" name="csrftoken" value="<?php echo $_SESSION['csrf_token']; ?>">
          <input type="hidden" id="user_id" name="user_id" value="<?php session_start(); echo $_SESSION['user_id']; ?>"> <!-- Get logged-in user ID -->
          
          <div class="mb-3">
            <label for="followup_date" class="form-label">Follow Up Date</label>
            <input type="date" class="form-control" id="followup_date" name="followup_date" value="<?php echo date('Y-m-d'); ?>" required>
          </div>
          
          <div class="mb-3">
            <label for="notes" class="form-label">Notes</label>
            <textarea class="form-control" id="notes" name="notes" required></textarea>
          </div>
          
          
          
    <!-- Status and Next Action Date (Side by Side) -->
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="status" class="form-label">Status</label>
              <select class="form-select" id="status" name="status" required onchange="toggleNextActionDate()">
                  <option value="">Select Status</option>
                <option value="In Follow Up">In Follow Up</option>
                <option value="Closed">Closed</option>
              </select>
            </div>

            <div class="col-md-6 mb-3">
              <label for="next_action_date" class="form-label">Next Action Date</label>
              <input type="date" class="form-control" id="next_action_date" name="next_action_date">
            </div>
          </div>

          <div class="mb-3">
            <button type="submit" class="btn btn-primary">Submit Follow Up</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Follow Up History Modal -->
<div class="modal fade" id="followUpHistoryModal" tabindex="-1" aria-labelledby="followUpHistoryModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="followUpModalLabel">Follow Up History for: <span id="historyEnquiryId"></span></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="followUpHistoryContent">
        <p class="text-muted">Loading history...</p>
      </div>
    </div>
  </div>
</div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script>
    // Function to toggle the 'required' attribute of next_action_date based on status
    function toggleNextActionDate() {
        var status = document.getElementById('status').value;
        var nextActionDateField = document.getElementById('next_action_date');

        if (status === 'Closed') {
            // If status is 'Closed', make next_action_date not required
            nextActionDateField.removeAttribute('required');
        } else {
            // If status is 'In Follow Up', make next_action_date required
            nextActionDateField.setAttribute('required', 'required');
        }
    }

    // Call the function on page load to ensure the correct state
    window.onload = function() {
        toggleNextActionDate();
    };
</script>
  <script src="./scripts/enquiry.js"></script>
<script>
document.getElementById('followUpForm').addEventListener('submit', function(event) {
    event.preventDefault(); // Prevent the default form submission

    const formData = new FormData(this); // Collect all the form data

fetch('submit_followup.php', {
    method: 'POST',
    body: formData,
})
.then(response => {
    // Check if the response status is OK
    if (!response.ok) {
        throw new Error('Server returned an error');
    }
    return response.json(); // Parse the response as JSON
})
.then(data => {
    console.log("Response data:", data);  // Log the data for debugging

    if (data.status === 'success') {
        alert('Follow-up added successfully!');
        location.reload();
        // $('#followUpModal').modal('hide'); // Optionally close the modal
    } else {
        alert(data.message); // Display the error message
    }
})
// .catch(error => {
//     console.error('Error:', error);
//     alert('There was an error processing your request. Please try again.');
// });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('.follow-up-history').forEach(function(button) {
    button.addEventListener('click', function() {
      const enquiryId = this.getAttribute('data-enquiry-id');
      const enquiryName = this.getAttribute('data-enquiry-name');
      
      // Set enquiry name in modal header
      document.getElementById('historyEnquiryId').textContent = enquiryName;

      const historyContent = document.getElementById('followUpHistoryContent');
      historyContent.innerHTML = '<p class="text-muted">Loading history...</p>';

      // Fetch history using AJAX
      fetch('get_followup_history.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'enquiry_id=' + encodeURIComponent(enquiryId)
      })
      .then(response => response.text())
      .then(data => {
        historyContent.innerHTML = data;
      })
      .catch(() => {
        historyContent.innerHTML = '<div class="alert alert-danger">Failed to load history.</div>';
      });
    });
  });
});
</script>

</body>

</html>