<?php  include ("auth.php");
include ("../config.php");
// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Enrolments - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">


</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Enrolments</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Enrolments</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
            
     
          <a href="enrolement.php" class="btn btn-primary btn-sm"><i class="bi bi-plus"></i> Add New</a>

          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Enrolment List</h5>
              
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
              <!-- Table with stripped rows -->
              <div class="table-responsive">
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Course</th>                    
                    <th>Batch</th>
                    <th>Student</th>
                    <th>Enrolment Date</th>
                    <th>Fee Status</th>
                    <th data-type="date" data-format="YYYY/DD/MM" style="white-space: nowrap;">Last Updated</th>
                    <th>Action</th>
                  </tr>
                </thead>
<tbody>
<?php
$sql = "
SELECT 
    e.enrolment_id, 
    e.cid, 
    e.bid, 
    e.mobile, 
    e.enrolment_date, 
    e.updated_at,
    e.fee_status,
    c.name AS course_name,
    b.title AS batch_title,
    s.name AS student_name
FROM enrolments e
LEFT JOIN course c ON e.cid = c.id
LEFT JOIN batch b ON e.bid = b.id
LEFT JOIN student s ON e.mobile = s.mobile
WHERE e.deleted_at IS NULL
ORDER BY e.enrolment_id DESC
";

$result = mysqli_query($conn, $sql);
$sl = 1;

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {

        // Build the fee history link (same logic as fee receipts)
        $link = "fee-history.php?mobile=" . base64_encode($row['mobile']) .
                "&cid=" . base64_encode($row['cid']) .
                "&bid=" . base64_encode($row['bid']);

        echo "<tr>";
        echo "<td style='white-space: nowrap;'>" . $sl . "</td>";
        echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['course_name'] ?? '-') . "</td>";
        echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['batch_title'] ?? '-') . "</td>";
        echo "<td style='white-space: nowrap;'>
                    " . htmlspecialchars($row['student_name'] ?? '-') . " (" . htmlspecialchars($row['mobile']) . ")
              </td>";
        echo "<td style='white-space: nowrap;'>" . date('d-m-Y', strtotime($row['enrolment_date'])) . "</td>";

        // Fee status badge for better visual distinction
        $statusClass = ($row['fee_status'] === 'Paid') ? 'success' :
                       (($row['fee_status'] === 'Partial') ? 'warning' : 'danger');

        echo "<td style='white-space: nowrap;'>
                <span class='badge bg-$statusClass'>" . htmlspecialchars($row['fee_status'] ?? '-') . "</span>
              </td>";

        echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['updated_at']) . "</td>";

        // Action buttons
        echo "<td style='white-space: nowrap;'>
                <a href='enrolement.php?id=" . base64_encode($row['enrolment_id']) . "' class='btn btn-sm btn-warning'>
                  <i class='bi bi-pen'></i>
                </a>
                <button class='btn btn-sm btn-danger' onclick='deleteEnrolment(" . $row['enrolment_id'] . ")'>
                  <i class='bi bi-trash'></i>
                </button>
                <a href='fee.php?eid=" . base64_encode($row['enrolment_id']) . "' class='btn btn-sm btn-info'>
                  <i class='bi bi-plus'></i> Fees
                </a>
                <a href='$link' class='btn btn-sm btn-success'>
                  <i class='bi bi-receipt'></i> Fees History
                </a>
              </td>";
        echo "</tr>";

        $sl++;
    }
} else {
    echo "<tr><td colspan='8' class='text-center'>No enrolment found.</td></tr>";
}

?>
</tbody>

              </table>
              </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/enrolement.js"></script>

</body>

</html>