<?php
header('Content-Type: application/json');
include('../config.php');
session_start();

// Ensure POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    echo json_encode(['success' => false, 'message' => 'CSRF validation failed.']);
    exit;
}

$response = ['success' => false, 'message' => 'Unknown error.'];

// Read form data
$action = $_POST['action'] ?? '';
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;

$enrolment_id = trim($_POST['enrolment_id'] ?? '');
$payment_date = trim($_POST['payment_date'] ?? date('Y-m-d'));
$next_payment_date = trim($_POST['next_payment_date'] ?? '');
$payment_mode = trim($_POST['payment_mode'] ?? '');
$reference = trim($_POST['reference'] ?? '');
$payment_amount = trim($_POST['payment_amount'] ?? 0);

// Validation for required fields
if (!in_array($action, ['delete'])) {
    if (empty($enrolment_id)) {
        echo json_encode(['success' => false, 'message' => 'Please select an enrolment.']);
        exit;
    }
    if (empty($payment_date)) {
        echo json_encode(['success' => false, 'message' => 'Please select payment date.']);
        exit;
    }
    if (empty($payment_mode)) {
        echo json_encode(['success' => false, 'message' => 'Please select payment mode.']);
        exit;
    }
    if (empty($payment_amount) || !is_numeric($payment_amount) || $payment_amount <= 0) {
        echo json_encode(['success' => false, 'message' => 'Please enter a valid payment amount.']);
        exit;
    }
}

// Fetch cid, bid, mobile from enrolments
$cid = $bid = $mobile = '';
if (!empty($enrolment_id)) {
    $stmt = $conn->prepare("SELECT cid, bid, mobile FROM enrolments WHERE enrolment_id = ? AND deleted_at IS NULL");
    $stmt->bind_param("i", $enrolment_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $cid = $row['cid'];
        $bid = $row['bid'];
        $mobile = $row['mobile']; // Already in enrolments table
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid enrolment selected.']);
        exit;
    }
    $stmt->close();
}

// === ADD NEW FEE RECEIPT ===
if ($action === 'Add') {
    try {
        $stmt = $conn->prepare("INSERT INTO fees_receipts (enrolment_id, cid, bid, mobile, payment_date,next_payment_date, payment_mode, payment_source, reference, payment_amount, payment_status) VALUES (?, ?, ?, ?, ?, ?,?, 'Center', ?, ?, 'Paid')");
        $stmt->bind_param("iiisssssd", $enrolment_id, $cid, $bid, $mobile, $payment_date,$next_payment_date, $payment_mode, $reference, $payment_amount);
        if ($stmt->execute()) {
            $stmt->close();

            // --- Update fee_status in enrolments ---
// Fetch total course fee and discount
$course_fee = $discount = 0;
$stmtFee = $conn->prepare("
    SELECT c.fees, c.discount 
    FROM course c
    JOIN batch b ON b.cid = c.id
    WHERE b.id = ?
");
$stmtFee->bind_param("i", $bid);
$stmtFee->execute();
$resFee = $stmtFee->get_result();
if ($resFee && $resFee->num_rows > 0) {
    $rowFee = $resFee->fetch_assoc();
    $course_fee = (float)$rowFee['fees'];
    $discount = (float)$rowFee['discount'];
}
$stmtFee->close();

// Calculate final payable after discount
$final_fee = $course_fee - $discount;

// Total payments made
$total_paid = 0;
$stmtPaid = $conn->prepare("SELECT SUM(payment_amount) AS total_paid FROM fees_receipts WHERE enrolment_id = ? AND deleted_at IS NULL");
$stmtPaid->bind_param("i", $enrolment_id);
$stmtPaid->execute();
$resPaid = $stmtPaid->get_result();
if ($resPaid && $resPaid->num_rows > 0) {
    $total_paid = (float)($resPaid->fetch_assoc()['total_paid'] ?? 0);
}
$stmtPaid->close();

// Determine fee_status based on discounted price
$fee_status = 'Pending';
if ($total_paid >= $final_fee) {
    $fee_status = 'Paid';
} elseif ($total_paid > 0 && $total_paid < $final_fee) {
    $fee_status = 'Partial';
}

// Update enrolments table
$stmtUpdate = $conn->prepare("UPDATE enrolments SET fee_status = ? WHERE enrolment_id = ?");
$stmtUpdate->bind_param("si", $fee_status, $enrolment_id);
$stmtUpdate->execute();
$stmtUpdate->close();


            $response = ['success' => true, 'message' => 'Fee receipt added successfully.', 'redirect' => 'fees.php'];
        } else {
            $response['message'] = 'Failed to add fee receipt.';
        }
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }
}

// === EDIT EXISTING FEE RECEIPT ===
elseif ($action === 'Edit' && $id > 0) {
    try {
        $stmt = $conn->prepare("UPDATE fees_receipts SET enrolment_id=?, cid=?, bid=?, mobile=?, payment_date=?, next_payment_date=?, payment_mode=?, reference=?,payment_amount=?, updated_at=NOW() WHERE id=?");
        $stmt->bind_param("iiisssssdi", $enrolment_id, $cid, $bid, $mobile, $payment_date,$next_payment_date, $payment_mode, $reference, $payment_amount, $id);
        if ($stmt->execute()) {
            $stmt->close();

            // --- Update fee_status in enrolments after edit ---
// --- Update fee_status in enrolments ---
// Fetch total course fee and discount
$course_fee = $discount = 0;
$stmtFee = $conn->prepare("
    SELECT c.fees, c.discount 
    FROM course c
    JOIN batch b ON b.cid = c.id
    WHERE b.id = ?
");
$stmtFee->bind_param("i", $bid);
$stmtFee->execute();
$resFee = $stmtFee->get_result();
if ($resFee && $resFee->num_rows > 0) {
    $rowFee = $resFee->fetch_assoc();
    $course_fee = (float)$rowFee['fees'];
    $discount = (float)$rowFee['discount'];
}
$stmtFee->close();

// Calculate final payable after discount
$final_fee = $course_fee - $discount;

// Total payments made
$total_paid = 0;
$stmtPaid = $conn->prepare("SELECT SUM(payment_amount) AS total_paid FROM fees_receipts WHERE enrolment_id = ? AND deleted_at IS NULL");
$stmtPaid->bind_param("i", $enrolment_id);
$stmtPaid->execute();
$resPaid = $stmtPaid->get_result();
if ($resPaid && $resPaid->num_rows > 0) {
    $total_paid = (float)($resPaid->fetch_assoc()['total_paid'] ?? 0);
}
$stmtPaid->close();

// Determine fee_status based on discounted price
$fee_status = 'Pending';
if ($total_paid >= $final_fee) {
    $fee_status = 'Paid';
} elseif ($total_paid > 0 && $total_paid < $final_fee) {
    $fee_status = 'Partial';
}

// Update enrolments table
$stmtUpdate = $conn->prepare("UPDATE enrolments SET fee_status = ? WHERE enrolment_id = ?");
$stmtUpdate->bind_param("si", $fee_status, $enrolment_id);
$stmtUpdate->execute();
$stmtUpdate->close();


            $response = ['success' => true, 'message' => 'Fee receipt updated successfully.', 'redirect' => 'fees.php'];
        } else {
            $response['message'] = 'Failed to update fee receipt.';
        }
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }
} 
elseif ($action === 'delete' && $id > 0) {
    // Mark as deleted
    $stmt = $conn->prepare("UPDATE fees_receipts SET deleted_at = NOW() WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        $stmt->close();

        // === Fetch enrolment_id, bid from deleted record ===
        $stmtInfo = $conn->prepare("SELECT enrolment_id, bid FROM fees_receipts WHERE id = ?");
        $stmtInfo->bind_param("i", $id);
        $stmtInfo->execute();
        $resInfo = $stmtInfo->get_result();
        if ($resInfo && $resInfo->num_rows > 0) {
            $info = $resInfo->fetch_assoc();
            $enrolment_id = $info['enrolment_id'];
            $bid = $info['bid'];
        }
        $stmtInfo->close();

        if (!empty($enrolment_id)) {
            // === Get course fee (consider discounted price) ===
            $course_fee = 0;
            $stmtFee = $conn->prepare("
                SELECT 
                    CASE 
                        WHEN c.discount > 0 THEN (c.fees - c.discount)
                        ELSE c.fees 
                    END AS effective_fee
                FROM course c
                JOIN batch b ON b.cid = c.id
                WHERE b.id = ?
            ");
            $stmtFee->bind_param("i", $bid);
            $stmtFee->execute();
            $resFee = $stmtFee->get_result();
            if ($resFee && $resFee->num_rows > 0) {
                $course_fee = $resFee->fetch_assoc()['effective_fee'];
            }
            $stmtFee->close();

            // === Get total remaining paid amount (excluding deleted) ===
            $total_paid = 0;
            $stmtPaid = $conn->prepare("
                SELECT SUM(payment_amount) AS total_paid 
                FROM fees_receipts 
                WHERE enrolment_id = ? 
                  AND deleted_at IS NULL
            ");
            $stmtPaid->bind_param("i", $enrolment_id);
            $stmtPaid->execute();
            $resPaid = $stmtPaid->get_result();
            if ($resPaid && $resPaid->num_rows > 0) {
                $total_paid = $resPaid->fetch_assoc()['total_paid'] ?? 0;
            }
            $stmtPaid->close();

            // === Determine new fee_status ===
            $fee_status = 'Pending';
            if ($total_paid >= $course_fee) {
                $fee_status = 'Paid';
            } elseif ($total_paid > 0 && $total_paid < $course_fee) {
                $fee_status = 'Partial';
            }

            // === Update enrolments table ===
            $stmtUpdate = $conn->prepare("UPDATE enrolments SET fee_status = ? WHERE enrolment_id = ?");
            $stmtUpdate->bind_param("si", $fee_status, $enrolment_id);
            $stmtUpdate->execute();
            $stmtUpdate->close();
        }

        $response = ['success' => true, 'message' => 'Fee receipt deleted successfully and fee status updated.'];
    } else {
        $response['message'] = 'Failed to delete fee receipt.';
    }
}

else {
    $response['message'] = 'Invalid action or missing ID.';
}

echo json_encode($response);
$conn->close();
exit;
?>



