<?php  include ("auth.php");
include ("../config.php");

// Decode parameters
$mobile = isset($_GET['mobile']) ? base64_decode($_GET['mobile']) : '';
$cid    = isset($_GET['cid']) ? base64_decode($_GET['cid']) : '';
$bid    = isset($_GET['bid']) ? base64_decode($_GET['bid']) : '';

// Validate
if (empty($mobile) || empty($cid) || empty($bid)) {
    die("Invalid parameters.");
}

// Fetch course info
$course = mysqli_fetch_assoc(mysqli_query($conn, "
    SELECT id, name, fees, discount 
    FROM course 
    WHERE id = '".intval($cid)."' AND deleted_at IS NULL
"));
if (!$course) {
    die("Course not found.");
}

// Fetch batch info
$batch = mysqli_fetch_assoc(mysqli_query($conn, "
    SELECT title 
    FROM batch 
    WHERE id = '".intval($bid)."' AND deleted_at IS NULL
"));
$batch_title = $batch['title'] ?? 'N/A';

// Fetch student info
$student = mysqli_fetch_assoc(mysqli_query($conn, "
    SELECT name, mobile 
    FROM student 
    WHERE mobile='".mysqli_real_escape_string($conn, $mobile)."' AND deleted_at IS NULL
"));
if (!$student) {
    die("Student not found.");
}

// Fetch fee receipts for this enrollment
$receipts = mysqli_query($conn, "
    SELECT * 
    FROM fees_receipts 
    WHERE cid='".intval($cid)."' 
      AND bid='".intval($bid)."' 
      AND mobile='".mysqli_real_escape_string($conn, $mobile)."' 
      AND deleted_at IS NULL
    ORDER BY payment_date ASC, id ASC
");

// Calculate totals
$total_paid = 0;
if ($receipts && mysqli_num_rows($receipts) > 0) {
    while ($r = mysqli_fetch_assoc($receipts)) {
        $total_paid += $r['payment_amount'];
        $all_receipts[] = $r;
    }
} else {
    $all_receipts = [];
}


$next_payment_due = null;
if (!empty($all_receipts)) {
    foreach ($all_receipts as $r) {
        if ($r['next_payment_date'] != '0000-00-00' && !empty($r['next_payment_date'])) {
            $next_payment_due = $r['next_payment_date'];
        }
    }
}


// Compute final values
$course_fee = (float)$course['fees'];
$discount = (float)$course['discount'];
$final_course_fee = $course_fee - $discount;
$balance = max($final_course_fee - $total_paid, 0);
if ($total_paid <= 0) {
    $payment_status = "Pending";
} elseif ($total_paid >= $final_course_fee) {
    $payment_status = "Fully Paid";
} else {
    $payment_status = "Partially Paid";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Fee History - <?php echo $settings['site_name']; ?></title>

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>

<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">

<div class="pagetitle">
    <h1>Fee History</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
            <li class="breadcrumb-item"><a href="fees.php">Fee Receipts</a></li>
            <li class="breadcrumb-item active">Fee History</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title mb-1">Student: <?php echo htmlspecialchars($student['name']); ?> (<?php echo htmlspecialchars($student['mobile']); ?>)</h5>
                    <p class="mb-1">Course: <strong><?php echo htmlspecialchars($course['name']); ?></strong></p>
                    <p class="mb-1">Batch: <strong><?php echo htmlspecialchars($batch_title); ?></strong></p>
                    <p class="mb-1">Course Fee: ₹<?php echo number_format($course_fee, 2); ?> 
                        <?php if ($discount > 0): ?>
                            <small class="text-success">(Discount: ₹<?php echo number_format($discount, 2); ?>)</small>
                        <?php endif; ?>
                    </p>
                    <p class="mb-3">Final Payable: <strong>₹<?php echo number_format($final_course_fee, 2); ?></strong></p>
                    <?php
$alert_class = 'warning'; // default

if ($payment_status === 'Fully Paid') {
    $alert_class = 'success';
} elseif ($payment_status === 'Pending') {
    $alert_class = 'danger';
}
?>
                    <div class="alert alert-<?php echo $alert_class; ?>">
                        <strong>Status:</strong> <?php echo $payment_status; ?><br>
                        <strong>Total Paid:</strong> ₹<?php echo number_format($total_paid, 2); ?><br>
                        <strong>Balance Left:</strong> ₹<?php echo number_format($balance, 2); ?>
                    </div>
                    <?php if ($next_payment_due): ?>
                     <p class="mb-3">
                      <strong>Next Payment Due:</strong> <?php echo date('d-M-Y', strtotime($next_payment_due)); ?>
                      </p>
                    <?php endif; ?>


                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Payment Date</th>
                                <th>Payment Mode</th>
                                <th>Reference</th>
                                <th>Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                        if (!empty($all_receipts)) {
                            $i = 1;
                            foreach ($all_receipts as $r) {
                                echo "<tr>
                                    <td>{$i}</td>
                                    <td>".htmlspecialchars(date('d-M-Y', strtotime($r['payment_date'])))."</td>
                                    <td>".htmlspecialchars($r['payment_mode'])."</td>
                                    <td>".htmlspecialchars($r['reference'])."</td>
                                    <td>₹".number_format($r['payment_amount'], 2)."</td>
                                    <td>".htmlspecialchars($r['payment_status'])."</td>
                                </tr>";
                                $i++;
                            }
                        } else {
                            echo "<tr><td colspan='6' class='text-center'>No payments found.</td></tr>";
                        }
                        ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="4" class="text-end">Total Paid:</th>
                                <th colspan="2">₹<?php echo number_format($total_paid, 2); ?></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Balance Left:</th>
                                <th colspan="2">₹<?php echo number_format($balance, 2); ?></th>
                            </tr>
                        </tfoot>
                    </table>

                   <a href="javascript:history.back()" class="btn btn-secondary">
  <i class="bi bi-arrow-left"></i> Back
</a>


                </div>
            </div>

        </div>
    </div>
</section>

</main>

<?php include("templates/footer.php"); ?>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>



