<?php  
include("auth.php");
include("../config.php");

// Initialize variables
$receipt = [];

// Fetch existing record for editing
if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);
    $stmt = $conn->prepare("SELECT * FROM fees_receipts WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result && $result->num_rows > 0) {
        $receipt = $result->fetch_assoc();
    } else {
        echo "Receipt not found.";
        exit;
    }
    $stmt->close();
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title><?php echo isset($_GET['id']) ? 'Edit' : 'Add'; ?> Fee Receipt - <?php echo $settings['site_name']; ?></title>

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <!-- Select2 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">

</head>

<body>

<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">

  <div class="pagetitle">
    <h1><?php echo isset($_GET['id']) ? 'Edit' : 'Add'; ?> Fee Receipt</h1>
    <nav>
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
        <li class="breadcrumb-item active">Fee Receipts</li>
      </ol>
    </nav>
  </div>

  <section class="section">
    <div class="row">
      <div class="col-lg-12">
        <a href="fees.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i> Fee Receipts List</a>

        <div class="card mt-2">
          <div class="card-body">
            <h5 class="card-title">Fee Receipt Details</h5>

          <?php
$selected_eid = '';
if (isset($_GET['eid'])) {
    $selected_eid = base64_decode($_GET['eid']);
}
?>

<form class="row g-3" id="feeForm">

<!-- Enrolment --> 
<div class="col-md-12">
     <label for="enrolment_id" class="form-label">Enrolment <span class="text-danger">*</span></label> 
     <select class="form-select" id="enrolment_id" name="enrolment_id" required> 
      <option value="">Select Enrolment</option> 
      <?php $enrolmentsQuery = mysqli_query($conn, " SELECT e.enrolment_id, s.name AS student_name, s.mobile, b.title AS batch_title, c.name AS course_name FROM enrolments e JOIN student s ON e.mobile = s.mobile JOIN batch b ON e.bid = b.id JOIN course c ON b.cid = c.id WHERE e.deleted_at IS NULL ORDER BY student_name ASC "); 
      while ($e = mysqli_fetch_assoc($enrolmentsQuery)) { 
      // preselect if form loaded via ?eid= 
      $selected = ''; 
      if (!empty($selected_eid) && $selected_eid == $e['enrolment_id']) { $selected = 'selected'; } 
      elseif (isset($receipt['enrolment_id']) && $receipt['enrolment_id'] == $e['enrolment_id']) { $selected = 'selected'; } 
      $text = "{$e['student_name']} ({$e['mobile']}) | Course: {$e['course_name']} | Batch: {$e['batch_title']}"; 
      echo "<option value='{$e['enrolment_id']}' $selected>$text</option>"; } ?> 
      </select> 
      </div>


              <!-- Payment Date -->
              <div class="col-md-6">
                <label for="payment_date" class="form-label">Payment Date <span class="text-danger">*</span></label>
                <input type="date" class="form-control" id="payment_date" name="payment_date" 
                  value="<?php echo isset($receipt['payment_date']) ? htmlspecialchars($receipt['payment_date']) : date('Y-m-d'); ?>" required>
              </div>

              <!-- Payment Mode -->
              <div class="col-md-6">
                <label for="payment_mode" class="form-label">Payment Mode <span class="text-danger">*</span></label>
                <select class="form-select" id="payment_mode" name="payment_mode" required>
                  <option value="">Select Mode</option>
                  <?php
                  $modes = ['Cash','Card','Google Pay','PhonePe','Paytm','BHIM','MobiKwik','Amazon Pay','Bank Transfer','Net Banking','QR Code Payment'];
                  foreach ($modes as $mode) {
                      $selected = (isset($receipt['payment_mode']) && $receipt['payment_mode'] == $mode) ? 'selected' : '';
                      echo "<option value='$mode' $selected>$mode</option>";
                  }
                  ?>
                </select>
              </div>
               <!-- Payment Amount -->
              <div class="col-md-4">
                <label for="payment_amount" class="form-label">Payment Amount <span class="text-danger">*</span></label>
                <input type="number" class="form-control" id="payment_amount" name="payment_amount" 
                  value="<?php echo isset($receipt['payment_amount']) ? htmlspecialchars($receipt['payment_amount']) : ''; ?>" 
                  placeholder="Enter amount" required>
              </div>
              
              <!-- Reference -->
              <div class="col-md-5">
                <label for="reference" class="form-label">Reference</label>
                <input type="text" class="form-control" id="reference" name="reference" 
                  value="<?php echo isset($receipt['reference']) ? htmlspecialchars($receipt['reference']) : ''; ?>" 
                  placeholder="Transaction or Reference ID">
              </div>

              <!-- Next Payment Date -->
              <div class="col-md-3">
                <label for="next_payment_date" class="form-label">Next Payment Date</label>
                <input type="date" class="form-control" id="next_payment_date" name="next_payment_date" 
                  value="<?php echo isset($receipt['next_payment_date']) ? htmlspecialchars($receipt['next_payment_datenext_payment_date']) : ''; ?>" >
              </div>
              
             

              <!-- Hidden fixed fields -->
              <input type="hidden" name="payment_source" value="Center">
              <input type="hidden" name="payment_status" value="Paid">
              <div id="msg"></div>
              <div class="col-md-12">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <?php if(isset($_GET['id'])) { ?>
                  <input type="hidden" name="id" value="<?php echo $id; ?>">
                  <input type="hidden" name="action" value="Edit">
                  <button class="btn btn-success" type="submit">Update</button>
                  <a href="fees.php" class="btn btn-secondary">Cancel</a>
                <?php } else { ?>
                  <input type="hidden" name="action" value="Add">
                  <button class="btn btn-success" type="submit">Submit</button>
                  <button class="btn btn-secondary" type="reset">Reset</button>
                <?php } ?>
              </div>

            </form>

          </div>
        </div>
      </div>
    </div>
  </section>
</main>

<?php include("templates/footer.php"); ?>

<!-- Scripts -->
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- jQuery (required for Select2) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
  $('#enrolment_id').select2({
    placeholder: "Search or select enrolment",
    allowClear: true,
    width: '100%'
  });
});
</script>

<script src="assets/js/main.js"></script>

<script src="./scripts/fee.js"></script>

</body>
</html>

