<?php  include ("auth.php");
include ("../config.php");
// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Fee Receipts - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">


</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Fee Receipts</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Fee Receipts</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
            
     
          <a href="fee.php" class="btn btn-primary btn-sm"><i class="bi bi-plus"></i> Add New</a>

<div class="card mt-2">
  <div class="card-body">
    <h5 class="card-title">Fee Receipts</h5>


    <div class="table-responsive">
      <table class="table datatable">
        <thead>
          <tr>
            <th>#</th>
            <th>Action</th>
            <th>Course</th>
            <th>Batch</th>
            <th>Student</th>
            <th>Date</th>
            <th>Mode</th>
            <th>Type</th>
            <th>Amount</th>
            <th>Reference</th>
            <th>Status</th>
            <th style='white-space: nowrap;'>Next Payment On</th>
            <th style='white-space: nowrap;'>Last Updated</th>
          </tr>
        </thead>
        <tbody>
<?php
$sql = "
SELECT 
  f.id, f.cid, f.bid, f.mobile, f.payment_date,f.next_payment_date, f.payment_mode, f.reference,f.payment_source, 
  f.payment_amount, f.payment_status, f.updated_at, f.status,
  c.name AS course_name,
  b.title AS batch_title,
  s.name AS student_name
FROM fees_receipts f
LEFT JOIN course c ON f.cid = c.id
LEFT JOIN batch b ON f.bid = b.id
LEFT JOIN student s ON f.mobile = s.mobile
WHERE f.deleted_at IS NULL
ORDER BY f.id DESC
";

$result = mysqli_query($conn, $sql);
$sl = 1;

if ($result && mysqli_num_rows($result) > 0) {
  while ($row = mysqli_fetch_assoc($result)) {
      
    $link = "fee-history.php?mobile=" . base64_encode($row['mobile']) . "&cid=" . base64_encode($row['cid']) . "&bid=" . base64_encode($row['bid']);

    echo "<tr>";
    echo "<td style='white-space: nowrap;'>{$sl}</td>";
     // Action buttons
    echo "<td style='white-space: nowrap;'>
            <a href='fee.php?id=" . base64_encode($row['id']) . "' class='btn btn-sm btn-warning'>
              <i class='bi bi-pen'></i>
            </a>
            <button class='btn btn-sm btn-danger' onclick='deleteFee(" . $row['id'] . ")'>
              <i class='bi bi-trash'></i>
            </button>
            <a href='fee_receipt.php?id=" . base64_encode($row['id']) . "' class='btn btn-sm btn-info'>
              <i class='bi bi-printer'></i> Receipt
            </a>
          </td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['course_name'] ?? '-') . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['batch_title'] ?? '-') . "</td>";
    echo "<td style='white-space: nowrap;'><a href='$link' class='text-primary text-decoration-underline'>" . htmlspecialchars($row['student_name'] ?? '-') . " (" . htmlspecialchars($row['mobile']) . ")</a></td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars(date('d-M-Y', strtotime($row['payment_date']))) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['payment_source']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['payment_mode']) . "</td>";
    echo "<td style='white-space: nowrap;'>₹" . htmlspecialchars($row['payment_amount']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['reference']) . "</td>";

    // Payment status badge
    $statusClass = ($row['payment_status'] === 'Paid') ? 'success' : (($row['payment_status'] === 'Pending') ? 'warning' : 'danger');
    echo "<td style='white-space: nowrap;'><span class='badge bg-{$statusClass}'>" . htmlspecialchars($row['payment_status']) . "</span></td>";
    if ($row['next_payment_date'] != '0000-00-00') {
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['next_payment_date']) . "</td>";
    } else {
    echo "<td style='white-space: nowrap;'>NA</td>";
    }

    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['updated_at']) . "</td>";

   
    echo "</tr>";
    $sl++;
  }
} else {
  echo "<tr><td colspan='12' class='text-center'>No fee receipts found.</td></tr>";
}
?>
        </tbody>
      </table>
    </div>
  </div>
</div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/fee.js"></script>
<input type="hidden" name="csrf_token" id="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">

</body>

</html>