<?php 
include("../config.php"); 

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Admin Login - <?php echo $settings['site_name'];?></title>

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">  
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/js/cripto.js"></script>
  <script>
  

$(document).ready(function(){
	
	$("#f1").on("submit", function(e) {
      e.preventDefault();
      
      $.ajax({
        url: "login-action.php",
        type: "POST",
        data: $(this).serialize(),
        dataType: "json",
        success: function(response) {
          if (response.status === "success") {
            $("#msg").html("<p style='color:green'>" + response.message + "</p>");
            setTimeout(() => window.location.href = "dashboard.php", 1000);
          } else {
            $("#msg").html("<p style='color:red'>" + response.message + "</p>");
          }
        },
        error: function() {
          $("#msg").html("<p style='color:red'>Server error!</p>");
          location.reload();
        }
      });
    });
  
  
      
});

  </script>


</head>

<body style="background-image: url('<?php echo $settings['login_background']; ?>');background-size: cover;background-repeat: no-repeat; background-position: center center;min-height: 100vh;">


  <main >
    <div class="container">

      <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
        <div class="container">
          <div class="row justify-content-center">
            <div class="col-lg-5 col-md-6 d-flex flex-column align-items-center justify-content-center">

              <div class="d-flex justify-content-center py-4">
               
              </div><!-- End Logo -->

              <div class="card mb-3" style="border-radius:30px;">

                <div class="card-body" >

                  <div class="pt-4 pb-2">
                    <h5 class="card-title text-center pb-0 fs-4"><?= $settings['site_name'] ?></h5>
                    <h6 class="text-center">Admin Login</h6>
                  </div>

                  <form id="f1" class="row g-3 needs-validation" novalidate>

                    <div class="col-12">
                      <label for="yourUsername" class="form-label">Email Address</label>
                      <div class="input-group has-validation">
                        <input placeholder="Enter email" type="text" name="email" class="form-control" id="email" required>
                        <div class="invalid-feedback">Please enter email.</div>
                      </div>
                    </div>

                    <div class="col-12">
                      <label for="yourPassword" class="form-label">Password</label>
                      <input placeholder="Enter password" type="password" name="password" class="form-control" id="password" required>
                      <div class="invalid-feedback">Please enter password!</div>
                    </div>


                   <div class="col-12">
                      <!-- Custom CAPTCHA -->
                      <img src="captcha.php" alt="CAPTCHA"><br>
                      <input type="text" name="captcha" placeholder="Enter CAPTCHA" required><br>
  
                    </div>
                   
                   
                   
  
  
                    <div class="col-12">
                      <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                      <button id="btn1" name="btn1" class="btn btn-primary w-100" type="submit">Login</button>
                    </div>

                    <div id="msg"></div>
                    
                  </form>

                </div>
              </div>

              <div class="credits text-center">
                  <span>© <?php echo date("Y"); ?>, All Rights Reserved -  <?= $settings['site_name'] ?>.</span><br>Designed by
      <a href="<?= $settings['developer_website'] ?>">  <?= $settings['developer'] ?></a>
              </div>

            </div>
          </div>
        </div>

      </section>

    </div>
  </main><!-- End #main -->

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>

</body>

</html>