<?php
include("auth.php");
include("../config.php");

// Ensure that the request method is POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

$response = ['success' => false, 'message' => 'Something went wrong.'];


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action']; // Either 'Add' or 'Edit'
    $id = $_POST['id'] ?? null; // If it's an edit, id will be provided
    $mediaTitle = $_POST['media_title'];
    $mediaType = $_POST['type'];
    $mediaUrl = $_POST['media_url'] ?? '';

    // Check if it's an edit or add action
    if ($action === 'Edit' && !empty($id)) {
        // Retrieve the existing media details before performing any update
        $stmt = $conn->prepare("SELECT media_url, type FROM media WHERE media_id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $existingMedia = $result->fetch_assoc();
        $existingMediaUrl = $existingMedia['media_url'];
        $existingMediaType = $existingMedia['type'];
        $stmt->close();

        // Handle editing based on type
        if ($existingMediaType === 'Links' || $existingMediaType === 'Video') {
            // If previous type is Links or Video, and it's being changed to a file type (Image, PDF), we need to ensure a file is uploaded
            if ($mediaType === 'Image' || $mediaType === 'PDF') {
                // If no file uploaded, show error
                if (empty($_FILES['media_url']['name'])) {
                    $response['message'] = 'Please upload a file for this media type.';
                    echo json_encode($response);
                    exit;
                } else {
                    // File is uploaded, proceed to upload
                    $uploadResult = handleFileUpload($mediaType);
                    if ($uploadResult['success']) {
                        $mediaUrl = $uploadResult['media_url'];
                    } else {
                        $response['message'] = $uploadResult['message'];
                        echo json_encode($response);
                        exit;
                    }
                }
            } else {
                // If no change in type or URL is provided for Links/Video, just update with URL
                $mediaUrl = $_POST['media_url']; // Ensure media_url is used for Links/Video
            }
        } else {
            // If the type is changing between two file types (e.g., Image to PDF or vice versa)
            if (($existingMediaType === 'Image' || $existingMediaType === 'PDF') && 
                ($mediaType === 'Image' || $mediaType === 'PDF')) {
                // If the file type is changing but no new file is uploaded, throw an error
                if (empty($_FILES['media_url']['name'])) {
                    $response['message'] = 'Please upload a new file to update the media type.';
                    echo json_encode($response);
                    exit;
                } else {
                    // New file is uploaded, proceed to handle the file upload
                    $uploadResult = handleFileUpload($mediaType);
                    if ($uploadResult['success']) {
                        $mediaUrl = $uploadResult['media_url'];
                    } else {
                        $response['message'] = $uploadResult['message'];
                        echo json_encode($response);
                        exit;
                    }
                }
            } else {
                // If no change in file type, we can retain the previous media URL
                $mediaUrl = $_POST['media_url']; // Use the URL as it is
            }
        }
    } else if ($action === 'Add') {
        // Add case: handle the file upload if required
        $uploadResult = handleFileUpload($mediaType); // Pass media type for conditional upload
        if ($uploadResult['success']) {
            $mediaUrl = $uploadResult['media_url'];
        } else {
            $response['message'] = $uploadResult['message'];
            echo json_encode($response);
            exit;
        }
    }

    // Now insert or update in the database
    if ($action === 'Add') {
        $stmt = $conn->prepare("INSERT INTO media (media_title, type, media_url) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $mediaTitle, $mediaType, $mediaUrl);
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Media added successfully!', 'redirect' => 'medias.php'];
        } else {
            $response['message'] = 'Error adding media.';
        }
        $stmt->close();
    } else if ($action === 'Edit') {
        $stmt = $conn->prepare("UPDATE media SET media_title = ?, type = ?, media_url = ? WHERE media_id = ?");
        $stmt->bind_param("sssi", $mediaTitle, $mediaType, $mediaUrl, $id);
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Media updated successfully!', 'redirect' => 'medias.php'];
        } else {
            $response['message'] = 'Error updating media.';
        }
        $stmt->close();
    }
    else if ($action === 'delete') {
        $stmt = $conn->prepare("UPDATE media SET deleted_at = NOW() WHERE media_id = ?");
        $stmt->bind_param("i",  $id);
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Media deleted successfully.'];
        } else {
            $response['message'] = 'Failed to delete media.';
        }

        $stmt->close();
    }
    echo json_encode($response);
}

// Handle file upload logic (for Add and Edit)
function handleFileUpload($mediaType) {
    $uploadDirectory = "../uploads/media_files/";
    $allowedFileTypes = ['image/jpeg', 'image/png', 'application/pdf', 'application/msword'];

    // Check if a file upload is required based on media type
    if ($mediaType === 'Video' || $mediaType === 'Links') {
        // For video or link, no file upload is needed, just return the text URL
        return ['success' => true, 'media_url' => $_POST['media_url']];
    }

    // Otherwise, proceed with file upload
    if (isset($_FILES['media_url']) && $_FILES['media_url']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['media_url'];
        $fileTmpName = $file['tmp_name'];
        $fileName = basename($file['name']);
        $fileSize = $file['size'];
        $fileType = $file['type'];

        // Check file type and size
        if (!in_array($fileType, $allowedFileTypes)) {
            return ['success' => false, 'message' => 'Invalid file type.'];
        }
        if ($fileSize > 5000000) { // 5MB limit
            return ['success' => false, 'message' => 'File is too large.'];
        }

        // Move the uploaded file to the desired directory
        $uploadPath = $uploadDirectory . $fileName;
        if (move_uploaded_file($fileTmpName, $uploadPath)) {
            return ['success' => true, 'media_url' => 'uploads/media_files/'.$fileName];
        } else {
            return ['success' => false, 'message' => 'Error uploading file.'];
        }
    }

    return ['success' => false, 'message' => 'No file uploaded.'];
}
?>




