<?php  include ("auth.php");
include ("../config.php");

// Fetch settings
$sql = "SELECT * FROM settings LIMIT 1"; // Assuming only one row of settings
$result = $conn->query($sql);
$settings = $result->fetch_assoc();

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Payment Settings - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

</head>

<body>

  <?php include("templates/header.php");?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Payment Settings</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Payment Settings</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-body pt-5">

<form id="settings_payment" enctype="multipart/form-data" action="settings-action.php" method="POST">

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">API Id</label>
    <div class="col-sm-10">
      <input type="text" name="api_id" id="api_id" placeholder="Enter api id" class="form-control" value="<?= htmlspecialchars($settings['api_id']) ?>" >
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">API Key</label>
    <div class="col-sm-10">
      <input type="text" name="api_key" id="api_key" placeholder="Enter api key" class="form-control" value="<?= htmlspecialchars($settings['api_key']) ?>">
    </div>
  </div>


  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Secret Key</label>
    <div class="col-sm-10">
      <input type="text" name="secret_key" id="secret_key" placeholder="Enter secret key" class="form-control" value="<?= htmlspecialchars($settings['secret_key']) ?>" >
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">UPI Id</label>
    <div class="col-sm-10">
      <input type="text" name="upi_id" id="upi_id" placeholder="Enter upi id" class="form-control" value="<?= htmlspecialchars($settings['upi_id']) ?>">
    </div>
  </div>
  
    <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Display Name</label>
    <div class="col-sm-10">
      <input type="text" name="display_name_payment" id="display_name_payment" placeholder="Enter Display Name" class="form-control" value="<?= htmlspecialchars($settings['display_name_payment']) ?>">
    </div>
  </div>


  <div class="row mb-3">
    <div class="col-sm-10 offset-sm-2">
      <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
      <button type="submit" class="btn btn-primary">Update Settings</button>
    </div>
  </div>

</form>

<div id="msg"></div>

          </div>
        </div>

      </div>
    </div>
  </section>

  </main><!-- End #main -->

     <?php include("templates/footer.php"); ?>
  

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/settings.js"></script>

</body>

</html>