document.addEventListener("DOMContentLoaded", function () {
  const form = document.getElementById("change-password-form");

  form.addEventListener("submit", function (e) {
    e.preventDefault();

    const old_password = document.getElementById("old_password").value.trim();
    const new_password = document.getElementById("new_password").value.trim();
    const confirm_password = document.getElementById("confirm_password").value.trim();

    const msgDiv = document.getElementById("change-password-msg");
    msgDiv.innerHTML = "";

    if (new_password !== confirm_password) {
      msgDiv.innerHTML = `<div class="alert alert-danger">New password and confirmation do not match.</div>`;
      return;
    }

    fetch("change-password-action.php", {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify({
        old_password: old_password,
        new_password: new_password,
        confirm_password: confirm_password
      }),
    })
    .then(response => response.json())
    .then(data => {
      let alertClass = data.success ? 'alert-success' : 'alert-danger';
      msgDiv.innerHTML = `<div class="alert ${alertClass}">${data.message}</div>`;
      if (data.success) {
        form.reset();
      }
    })
    .catch(error => {
      msgDiv.innerHTML = `<div class="alert alert-danger">Something went wrong.</div>`;
      console.error("Error:", error);
    });
  });
});
