document.querySelectorAll('.assign-executive').forEach(function(selectElement) {
    selectElement.addEventListener('change', function() {
        var selectedUser = this.value;
        var enquiryId = this.getAttribute('data-enquiry-id');
        // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
        var csrfToken = document.querySelector('input[name="csrf_token"]').value;

        if (selectedUser) {
            // Confirm the assignment
            var selectedText = this.options[this.selectedIndex].text;
            if (confirm("Assign Enquiry to '" + selectedText + "'?")) {
                // If confirmed, send the data as form data
                var formData = new FormData();
                formData.append('action', 'assign');
                formData.append('id', enquiryId);
                formData.append('assigned_to', selectedUser);
                formData.append('csrf_token', csrfToken);

                fetch('enquiry-action.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // alert(data.message);
                        location.reload(); // Reload the page to reflect the changes
                    } else {
                        alert('Failed to assign enquiry: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred. Please try again.');
                });
            }
        }
        
          // Send the data
         xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
    });
});



// Form submission via AJAX
var form = document.getElementById('enquiryform'); // use the ID
form.addEventListener('submit', function(e) {
  e.preventDefault(); // prevent default submission

  // Get form field values
  var name = document.getElementById('name').value;
  var email = document.getElementById('email').value;
  var phone = document.getElementById('phone').value;

  // Validate name (alphanumeric and space only)
  var nameRegex = /[^a-zA-Z0-9\s]/g; // Matches any character that is NOT alphanumeric or space
  var cleanedName = name.replace(nameRegex, ''); // Remove invalid characters

  // Update the name field with the cleaned value
  document.getElementById('name').value = cleanedName;

  // Validate email (basic pattern)
  var emailRegex = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/;
  if (!emailRegex.test(email)) {
    alert("Please enter a valid email address.");
    return;
  }

  // Validate phone (basic pattern for a 10-digit phone number)
  var phoneRegex = /^[0-9]{10}$/;
  if (!phoneRegex.test(phone)) {
    alert("Please enter a valid 10-digit phone number.");
    return;
  }

  // Prepare form data
  var formData = new FormData(form);

  // Send AJAX request
  fetch('enquiry-action.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '';

    if (data.success) {
      msgDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
      
      // Optionally redirect after a short delay
      if (data.redirect) {
        setTimeout(function() {
          window.location.href = data.redirect;
        }, 1500);
      }

    } else {
      msgDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
    }
  })
  .catch(error => {
    console.error('Error:', error);
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
  });
});

// Delete Content
function deleteEnquiry(enquiryId) {
  // Confirm the action
  if (!confirm('Are you sure you want to delete this enquiry?')) {
    return;
  }

  // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
  var csrfToken = document.querySelector('input[name="csrf_token"]').value;

  // Prepare the data to be sent
  var data = {
    action: 'delete',
    id: enquiryId,
    csrf_token: csrfToken  // Include CSRF token in the data
  };

  // Perform the AJAX request
  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'enquiry-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  // Handle the response
xhr.onload = function() {
  if (xhr.status === 200) {
    var response = JSON.parse(xhr.responseText);
    console.log(response);  // Log the response for debugging
    if (response.success === true) {
      location.reload();  // Reload the page on success
    } else {
      alert(response.message);  // Show error message
    }
  } else {
    alert('An error occurred while deleting the enquiry.');
  }
};


  // Send the data
  xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
}





