// Auto-fill course ID when batch changes
  document.getElementById('bid').addEventListener('change', function () {
    var selected = this.options[this.selectedIndex];
    var cid = selected.getAttribute('data-cid');
    document.getElementById('cid').value = cid || '';
  });

  // Trigger once on page load if editing existing record
  window.addEventListener('load', function () {
    const selectedBatch = document.getElementById('bid');
    if (selectedBatch.value) {
      const cid = selectedBatch.options[selectedBatch.selectedIndex].getAttribute('data-cid');
      document.getElementById('cid').value = cid || '';
    }
  });
  
// Form submission via AJAX
var form = document.getElementById('enrolementform'); // use the ID
form.addEventListener('submit', function(e) {
  e.preventDefault();

  const submitBtn = form.querySelector('button[type="submit"]');
  submitBtn.disabled = true;
  submitBtn.textContent = 'Please wait...';

  const formData = new FormData(form);

  fetch('enrolement-action.php', { method: 'POST', body: formData })
    .then(response => response.json())
    .then(data => {
      const msgDiv = document.getElementById('msg');
      msgDiv.innerHTML = '';

      if (data.success) {
        msgDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
        if (data.redirect) {
          setTimeout(() => window.location.href = data.redirect, 1500);
        }
      } else {
        msgDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
      }
    })
    .catch(error => {
      console.error('Error:', error);
      document.getElementById('msg').innerHTML = '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
    })
    .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = form.querySelector('input[name="action"]').value === 'Edit' ? 'Update' : 'Submit';
    });
});


// Delete Content
function deleteEnrolment(enrolementId) {
  // Confirm the action
  if (!confirm('Are you sure you want to delete this Enrolment?')) {
    return;
  }

  // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
  var csrfToken = document.querySelector('input[name="csrf_token"]').value;

  // Prepare the data to be sent
  var data = {
    action: 'delete',
    id: enrolementId,
    csrf_token: csrfToken  // Include CSRF token in the data
  };

  // Perform the AJAX request
  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'enrolement-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  // Handle the response
  xhr.onload = function() {
    if (xhr.status === 200) {
      var response = JSON.parse(xhr.responseText);

      // Check if the response was successful
      if (response.success === true) {
        location.reload();  // Reload the page on success
      } else {
        alert(response.message);  // Show error message
      }
    } else {
      alert('An error occurred while deleting the enrolment.');
    }
  };

  // Send the data
  xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
}
