// Initialize Quill editors
var quillQuestion = new Quill('#quillEditorquestion', {
  theme: 'snow',
  modules: {
    toolbar: [
      [{ header: [1, 2, 3, false] }],
      ['bold', 'italic', 'underline'],
      [{ 'color': [] }, { 'background': [] }],
      ['link', 'code-block'],
      [{ list: 'ordered' }, { list: 'bullet' }]
    ]
  },
  placeholder: 'Enter Question here...'
});

var quillAnswer = new Quill('#quillEditoranswer', {
  theme: 'snow',
  modules: {
    toolbar: [
      [{ header: [1, 2, 3, false] }],
      ['bold', 'italic', 'underline'],
      [{ 'color': [] }, { 'background': [] }],
      ['link', 'code-block'],
      [{ list: 'ordered' }, { list: 'bullet' }]
    ]
  },
  placeholder: 'Enter Answer here...'
});

// Set initial values for editing
if (questionData) {
  quillQuestion.clipboard.dangerouslyPasteHTML(questionData);
}
if (answerData) {
  quillAnswer.clipboard.dangerouslyPasteHTML(answerData);
}

// Handle form submission
var form = document.getElementById('faqform');
form.addEventListener('submit', function(e) {
  e.preventDefault();

  // Check if content is empty (not just HTML tags)
  const questionText = quillQuestion.getText().trim();
  const answerText = quillAnswer.getText().trim();

  if (questionText === "") {
    document.getElementById('msg').innerHTML = '<div class="alert alert-danger">Question cannot be empty.</div>';
    return;
  }

  if (answerText === "") {
    document.getElementById('msg').innerHTML = '<div class="alert alert-danger">Answer cannot be empty.</div>';
    return;
  }

  // Sync HTML content to hidden fields
  document.getElementById('question').value = quillQuestion.root.innerHTML;
  document.getElementById('answer').value = quillAnswer.root.innerHTML;

  var formData = new FormData(form);

  fetch('faq-action.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = data.success
      ? '<div class="alert alert-success">' + data.message + '</div>'
      : '<div class="alert alert-danger">' + data.message + '</div>';

    if (data.success && data.redirect) {
      setTimeout(() => {
        window.location.href = data.redirect;
      }, 1500);
    }
  })
  .catch(error => {
    console.error('Error:', error);
    document.getElementById('msg').innerHTML = '<div class="alert alert-danger">Something went wrong.</div>';
  });
});


// Delete Content
function deleteFAQ(faqId) {
  // Confirm the action
  if (!confirm('Are you sure you want to delete this FAQ?')) {
    return;
  }

  // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
  var csrfToken = document.querySelector('input[name="csrf_token"]').value;

  // Prepare the data to be sent
  var data = {
    action: 'delete',
    id: faqId,
    csrf_token: csrfToken  // Include CSRF token in the data
  };

  // Perform the AJAX request
  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'faq-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  // Handle the response
  xhr.onload = function() {
    if (xhr.status === 200) {
      var response = JSON.parse(xhr.responseText);

      // Check if the response was successful
      if (response.success === true) {
        location.reload();  // Reload the page on success
      } else {
        alert(response.message);  // Show error message
      }
    } else {
      alert('An error occurred while deleting the FAQ.');
    }
  };

  // Send the data
  xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
}






