

// Form submission via AJAX
var form = document.getElementById('studentform'); // use the ID
form.addEventListener('submit', function(e) {
  e.preventDefault(); // prevent default submission


  // Prepare form data
  var formData = new FormData(form);

  // Send AJAX request
fetch('student-action.php', { method: 'POST', body: formData })
  .then(response => response.json())
  .then(data => {
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '';

    if (data.success) {
      msgDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
      
      // Optionally redirect after a short delay
      if (data.redirect) {
        setTimeout(function() {
          window.location.href = data.redirect;
        }, 1500);
      }

    } else {
      msgDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
    }
  })
  .catch(error => {
    console.error('Error:', error);
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
  });
});

// Delete Content
function deleteStudent(studentId) {
  // Confirm the action
  if (!confirm('Are you sure you want to delete this student?')) {
    return;
  }

  // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
  var csrfToken = document.querySelector('input[name="csrf_token"]').value;

  // Prepare the data to be sent
  var data = {
    action: 'delete',
    id: studentId,
    csrf_token: csrfToken  // Include CSRF token in the data
  };

  // Perform the AJAX request
  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'student-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  // Handle the response
  xhr.onload = function() {
    if (xhr.status === 200) {
      var response = JSON.parse(xhr.responseText);

      // Check if the response was successful
      if (response.success === true) {
        location.reload();  // Reload the page on success
      } else {
        alert(response.message);  // Show error message
      }
    } else {
      alert('An error occurred while deleting the student.');
    }
  };

  // Send the data
  xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
}






