<?php
include '../config.php';

if (ob_get_length()) ob_clean();
header('Content-Type: application/json');

try {
    // 🔒 CSRF validation
    if(!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']){
        throw new Exception('Invalid CSRF token');
    }

    $settingsId = 1;

    /* =========================================================
       🔹 Helper Functions
    ========================================================== */
    function sanitize($data){
        return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
    }

    function uploadFile($fileInput, $targetFolder, $oldFile='') {
        if(isset($_FILES[$fileInput]) && $_FILES[$fileInput]['error'] == 0){
            $filename = time().'_'.basename($_FILES[$fileInput]['name']);
            $targetPath = $targetFolder . $filename;
            if(move_uploaded_file($_FILES[$fileInput]['tmp_name'], $targetPath)){
                if($oldFile && file_exists($oldFile)){
                    @unlink($oldFile);
                }
                return $targetPath;
            } else {
                throw new Exception("Failed to move uploaded file for $fileInput");
            }
        }
        return $oldFile;
    }

    /* =========================================================
       🔹 Plain Fields — matched exactly to your table
    ========================================================== */
    $plainFields = [
        'site_name','tagline','about_site','email','phone','whatsapp','address',
        'base_url','developer','developer_website','google_map','facebook','instagram',
        'x','linkedin','youtube','site_title','meta_description','meta_keywords','registration_no_prefix','website_status','course_mode',

        // Email section
        'smtp_host','port_number','username','password','sender_email','display_name_email',

        // Payment section
        'api_id','api_key','secret_key','upi_id','display_name_payment',

        // WhatsApp / Misc
        'whatsapp_url'
    ];

    /* =========================================================
       🔹 HTML/Rich Text Fields
    ========================================================== */
    $htmlFields = [
        'privacy_policy','term_and_conditions','disclaimer','head_scripts','footer_scripts'
    ];

    /* =========================================================
       🔹 Collect Form Data
    ========================================================== */
    $data = [];

    // Sanitize plain fields
    foreach($plainFields as $f){
        if(isset($_POST[$f])) {
            $data[$f] = sanitize($_POST[$f]);
        }
    }

    // Preserve raw HTML for editor fields
    foreach($htmlFields as $f){
        if(isset($_POST[$f])) {
            $data[$f] = trim($_POST[$f]);
            if(strip_tags($data[$f]) === '') $data[$f] = '';
        }
    }

    /* =========================================================
       🔹 Handle File Uploads
    ========================================================== */
    $oldSettings = $conn->query("SELECT * FROM settings WHERE id=$settingsId")->fetch_assoc();

    $data['logo']             = uploadFile('logo', '../assets/images/', $oldSettings['logo']);
    $data['logo_light']       = uploadFile('logo_light', '../assets/images/', $oldSettings['logo_light']);
    $data['fevicon']          = uploadFile('fevicon', '../assets/images/', $oldSettings['fevicon']);
    $data['og_image']         = uploadFile('og_image', '../assets/images/', $oldSettings['og_image']);
    $data['login_background'] = uploadFile('login_background', './assets/img/', $oldSettings['login_background']);

    /* =========================================================
       🔹 Prepare SQL Update
    ========================================================== */
    $setPart = [];
    foreach($data as $k=>$v){
        $v = $conn->real_escape_string($v);
        $setPart[] = "`$k`='$v'";
    }
    $setQuery = implode(',', $setPart);

    /* =========================================================
       🔹 Execute Update
    ========================================================== */
    if($conn->query("UPDATE settings SET $setQuery WHERE id=$settingsId")){
        echo json_encode(['status'=>'success','message'=>'Settings updated successfully!']);
    } else {
        throw new Exception($conn->error);
    }

} catch(Exception $e){
    echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
}
?>

