<?php  include ("auth.php");
include ("../config.php");

// Fetch settings
$sql = "SELECT * FROM settings LIMIT 1"; // Assuming only one row of settings
$result = $conn->query($sql);
$settings = $result->fetch_assoc();

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>General Settings - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

</head>

<body>

  <?php include("templates/header.php");?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>General Settings</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">General Settings</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-body pt-5">

<form id="settings_general" enctype="multipart/form-data" action="settings-action.php" method="POST">

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Site Name</label>
    <div class="col-sm-10">
      <input type="text" name="site_name" id="site_name" placeholder="Enter Site Name" class="form-control" value="<?= htmlspecialchars($settings['site_name']) ?>" >
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Tagline</label>
    <div class="col-sm-10">
      <input type="text" name="tagline" id="tagline" placeholder="Enter Tagline" class="form-control" value="<?= htmlspecialchars($settings['tagline']) ?>">
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">About Site</label>
    <div class="col-sm-10">
      <textarea name="about_site" id="about_site" placeholder="Write something about your site" class="form-control"><?= htmlspecialchars($settings['about_site']) ?></textarea>
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Email</label>
    <div class="col-sm-10">
      <input type="email" name="email" id="email" placeholder="Enter Email" class="form-control" value="<?= htmlspecialchars($settings['email']) ?>" >
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Phone</label>
    <div class="col-sm-10">
      <input type="number" name="phone" id="phone" placeholder="Enter Phone Number" class="form-control" value="<?= htmlspecialchars($settings['phone']) ?>">
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">WhatsApp</label>
    <div class="col-sm-10">
      <input type="number" name="whatsapp" id="whatsapp" placeholder="Enter Whatsapp Number" class="form-control" value="<?= htmlspecialchars($settings['whatsapp']) ?>">
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Address</label>
    <div class="col-sm-10">
      <textarea name="address" id="address" placeholder="Enter Full Address" class="form-control"><?= htmlspecialchars($settings['address']) ?></textarea>
    </div>
  </div>
  
    <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Base Url</label>
    <div class="col-sm-10">
      <textarea name="base_url" id="base_url" placeholder="Enter your sites' base url" class="form-control"><?= htmlspecialchars($settings['base_url']) ?></textarea>
    </div>
  </div>
  
<div class="row mb-3">
  <label class="col-sm-2 col-form-label">Privacy Policy</label>
  <div class="col-sm-10">
    <div id="privacy_policy_editor" class="form-control" style="height: 200px;"><?= htmlspecialchars($settings['privacy_policy']) ?></div>
    <input type="hidden" name="privacy_policy" id="privacy_policy">
  </div>
</div>

<div class="row mb-3">
  <label class="col-sm-2 col-form-label">Term & Conditions</label>
  <div class="col-sm-10">
    <div id="term_editor" class="form-control" style="height: 200px;"><?= htmlspecialchars($settings['term_and_conditions']) ?></div>
    <input type="hidden" name="term_and_conditions" id="term_and_conditions">
  </div>
</div>

<div class="row mb-3">
  <label class="col-sm-2 col-form-label">Disclaimer</label>
  <div class="col-sm-10">
    <div id="disclaimer_editor" class="form-control" style="height: 200px;"><?= htmlspecialchars($settings['disclaimer']) ?></div>
    <input type="hidden" name="disclaimer" id="disclaimer">
  </div>
</div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Reg No. Prefix</label>
    <div class="col-sm-10">
      <input type="text" name="registration_no_prefix" id="registration_no_prefix" placeholder="Enter a prefix you would like in your generated reg no. ex: IKP " class="form-control" value="<?= htmlspecialchars($settings['registration_no_prefix']) ?>">

    </div>
  </div>
  
<div class="row mb-3">
  <label class="col-sm-2 col-form-label">Enable Website</label>
  <div class="col-sm-10 d-flex align-items-center gap-3">
    <div class="form-check">
      <input class="form-check-input" type="radio" name="website_status" id="website_yes" value="Yes"
        <?= ($settings['website_status'] === 'Yes') ? 'checked' : '' ?>>
      <label class="form-check-label" for="website_yes">Yes</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="website_status" id="website_no" value="No"
        <?= ($settings['website_status'] === 'No') ? 'checked' : '' ?>>
      <label class="form-check-label" for="website_no">No</label>
    </div>
  </div>
</div>

<div class="row mb-3">
  <label class="col-sm-2 col-form-label">Course Mode</label>
  <div class="col-sm-10 d-flex align-items-center gap-3">
    <div class="form-check">
      <input class="form-check-input" type="radio" name="course_mode" id="mode_hybrid" value="Hybrid"
        <?= ($settings['course_mode'] === 'Hybrid') ? 'checked' : '' ?>>
      <label class="form-check-label" for="mode_hybrid">Hybrid</label>
    </div>

    <div class="form-check">
      <input class="form-check-input" type="radio" name="course_mode" id="mode_online" value="Online"
        <?= ($settings['course_mode'] === 'Online') ? 'checked' : '' ?>>
      <label class="form-check-label" for="mode_online">Online</label>
    </div>

    <div class="form-check">
      <input class="form-check-input" type="radio" name="course_mode" id="mode_offline" value="Offline"
        <?= ($settings['course_mode'] === 'Offline') ? 'checked' : '' ?>>
      <label class="form-check-label" for="mode_offline">Offline</label>
    </div>
  </div>
</div>


  <div class="row mb-3">
    <div class="col-sm-10 offset-sm-2">
      <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
      <button type="submit" class="btn btn-primary">Update Settings</button>
    </div>
  </div>

</form>

<div id="msg"></div>

          </div>
        </div>

      </div>
    </div>
  </section>

  </main><!-- End #main -->

     <?php include("templates/footer.php"); ?>
  

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/settings.js"></script>

</body>

</html>