<?php
header('Content-Type: application/json');
include('../config.php');
session_start();

// Ensure that the request method is POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

$response = ['success' => false, 'message' => 'Unknown error'];


// Get POST parameters
$action = $_POST['action'] ?? '';
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$type = trim($_POST['type'] ?? '');
$name = trim($_POST['name'] ?? '');
$review = $_POST['review'] ?? '';

// Sanitize content_title to remove HTML and scripts
$type = htmlspecialchars(strip_tags($type), ENT_QUOTES, 'UTF-8');
$name = htmlspecialchars(strip_tags($name), ENT_QUOTES, 'UTF-8');
$review = htmlspecialchars(strip_tags($review), ENT_QUOTES, 'UTF-8');

// Validate that required fields are not empty
if ($action!='delete' && (empty($type) || empty(trim(strip_tags($name))) || empty(trim(strip_tags($name))) )) {
    $response['message'] = 'Name,Type and review cannot be empty.';
    echo json_encode($response);
    exit;
}

// Handle the delete action via POST (AJAX)
if ($action === 'delete' && $id > 0) {
    try {
        // Prepare and execute the soft delete query
        $stmt = $conn->prepare("UPDATE testimonials SET deleted_at = NOW() WHERE testimonial_id = ?");
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Testimonial deleted successfully.'];
        } else {
            $response['message'] = 'Failed to delete testimonial.';
        }

        $stmt->close();
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }

    // Return JSON response after the delete action
    echo json_encode($response);
    $conn->close();
    exit;
}

// For Add and Edit actions
try {
    if ($action === 'Add') {
        // Insert new content
        $stmt = $conn->prepare("INSERT INTO testimonials (type, name, review) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $type, $name, $review);

        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Testimonial added successfully', 'redirect' => 'testimonials.php'];
        } else {
            $response['message'] = 'Failed to add testimonial';
        }

        $stmt->close();

    } elseif ($action === 'Edit' && $id > 0) {
        // Edit existing content
        $stmt = $conn->prepare("UPDATE testimonials SET type=?, name=?, review=?, updated_at=NOW() WHERE testimonial_id=?");
        $stmt->bind_param("sssi", $type, $name, $review, $id);

        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Testimonial updated successfully', 'redirect' => 'testimonials.php'];
        } else {
            $response['message'] = 'Failed to update testimonial';
        }

        $stmt->close();

    } else {
        $response['message'] = 'Invalid action or missing testimonial ID';
    }

} catch (Exception $e) {
    $response['message'] = 'Error: ' . $e->getMessage();
}

// Return JSON response
echo json_encode($response);
$conn->close();
exit;
?>