<?php  
include("auth.php");
include("../config.php");

$testimonial = []; // default empty array

if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);

    // Prepare the statement
    $stmt = $conn->prepare("SELECT * FROM testimonials WHERE testimonial_id = ?");
    $stmt->bind_param("i", $id); // "i" = integer

    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $testimonial = $result->fetch_assoc();
    } else {
        // Optionally redirect or show an error if content not found
        echo "Testimonial not found.";
        exit;
    }
    $stmt->close();
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Testimonial <?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="../<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1><?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> Testimonial</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Testimonial</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <a href="testimonials.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i>Testimonials List</a>
          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Testimonial Details</h5>
              
               <form class="row g-3" id="testimonialform">
                   
<div class="col-md-6">
  <label for="type" class="form-label">Testimonial Type <span class="text-danger">*</span></label>
  <select class="form-control" id="type" name="type" required>
    <option value="">Select Type</option>
    <option value="Text" <?php echo (isset($testimonial['type']) && $testimonial['type'] === 'Text') ? 'selected' : ''; ?>>Text</option>
    <option value="Video" <?php echo (isset($testimonial['type']) && $testimonial['type'] === 'Video') ? 'selected' : ''; ?>>Video</option>
  </select>
</div>
                <div class="col-md-6">
                  <label for="fees" class="form-label">Testimonial By <span class="text-danger">*</span></label>
                  <input type="text" class="form-control" id="name" name="name" value="<?php echo isset($testimonial['name']) ? htmlspecialchars($testimonial['name']) : ''; ?>" placeholder="Enter Name" >
                </div>

                
                <div class="col-md-12">
                  <label for="review" class="form-label">Review<span class="text-danger">*</span></label>
                  <textarea type="text" class="form-control" id="review" name="review" placeholder="Enter text review or copy/paste video url" required><?php echo isset($testimonial['review']) ? htmlspecialchars($testimonial['review']) : ''; ?></textarea>
                </div>
                
                <div id="msg"></div>
                <div class="col-md-12">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                   <?php if(isset($_GET['id'])) {  ?>
                   <input type="hidden" class="form-control" id="id" name="id" value="<?php echo $id; ?>">
                   <input type="hidden" class="form-control" id="action" name="action" value="Edit">
                   <button class="btn btn-success" type="submit">Update</button>
                   <a href="testimonials.php" class="btn btn-secondary" type="button">Cancel</a>
                   
                   <?php } else { ?>
                   <input type="hidden" class="form-control" id="action" name="action" value="Add">
                   <button class="btn btn-success" type="submit">Submit</button>
                   <button class="btn btn-secondary" type="reset">Reset</button>
                   <?php } ?>
                </div>
              </form>

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
<script src="./scripts/testimonial.js"></script>

</body>

</html>