<?php include_once('./config.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <!--====== Required meta tags ======-->
  <meta charset="utf-8" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <!--====== Title ======-->
  <title><?= $settings['site_title'] ?></title>
  <meta name="description" content="<?= $settings['meta_description'] ?>">
  <meta name="keywords" content="<?= $settings['meta_keywords'] ?>">

  <!-- Social Media Open Graph -->
  <meta property="og:title" content="<?= $settings['site_title'] ?>">
  <meta property="og:description" content="<?= $settings['meta_description'] ?>">
  <meta property="og:type" content="website">
  <meta property="og:url" content="<?= $settings['base_url'] ?>">
  <meta property="og:image" content="<?= $settings['og_image'] ?>">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="<?= $settings['site_title'] ?>">
  <meta name="twitter:description" content="<?= $settings['meta_description'] ?>">
  <meta name="twitter:image" content="<?= $settings['og_image'] ?>">
  <?= $settings['head_scripts'] ?>

  <!--====== Favicon Icon ======-->

<link rel="icon" type="image/x-icon" href="<?= $settings['fevicon'] ?>">

  <!--====== Bootstrap css ======-->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css" />

  <!--====== Line Icons css ======-->
  <link rel="stylesheet" href="assets/css/lineicons.css" />

  <!--====== Tiny Slider css ======-->
  <link rel="stylesheet" href="assets/css/tiny-slider.css" />

  <!--====== gLightBox css ======-->
  <link rel="stylesheet" href="assets/css/glightbox.min.css" />

  <link rel="stylesheet" href="style.css" />
</head>

<body>

  <!--====== NAVBAR NINE PART START ======-->

  <section class="navbar-area navbar-nine">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <nav class="navbar navbar-expand-lg">
            <a class="navbar-brand" href="<?= $base_url ?>">
              <img src="<?= $settings['logo_light'] ?>" alt="Logo" width='220px' />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNine"
              aria-controls="navbarNine" aria-expanded="false" aria-label="Toggle navigation">
              <span class="toggler-icon"></span>
              <span class="toggler-icon"></span>
              <span class="toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse sub-menu-bar" id="navbarNine">
              <ul class="navbar-nav me-auto">
  <?php foreach ($sections as $section): ?>
    <?php if ($section['header_visibility'] == '1'): ?>
      <?php
        // Get the label
        $label = htmlspecialchars($section['name']);

        // Determine href ID
        switch ($section['name']) {
          case 'Home':
            $href = '#hero-area';
            break;
          case 'About IKP':
            $href = '#about';
            break;
          default:
            // Make lowercase, remove spaces and special characters if needed
            $href = '#' . strtolower(str_replace(' ', '', $section['name']));
            break;
        }
      ?>
      <li class="nav-item">
        <a class="page-scroll<?= $section['name'] == 'Home' ? ' active' : '' ?>" href="<?= $href ?>">
          <?= $label ?>
        </a>
      </li>
    <?php endif; ?>
  <?php endforeach; ?>
</ul>

            </div>

            <div class="d-none d-lg-inline-block text-white">
             <i class="lni lni-phone"></i> <?= $settings['phone'] ?>
            </div>
          </nav>
          <!-- navbar -->
        </div>
      </div>
      <!-- row -->
    </div>
    <!-- container -->
  </section>

  <!--====== NAVBAR NINE PART ENDS ======-->

  
 <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Home' && $section['visiblity'] == '1'): ?>
  <!-- Start header Area -->
  <section id="hero-area" class="header-area header-eight">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6 col-md-12 col-12 order-2 order-md-1 mt-3">
          <div class="header-content">
            <h1> <?= getContent($conn,'Hero Title') ?></h1>
            <p>
              <?= getContent($conn,'Hero Description') ?>
            </p>
            <div class="button">
              <a href="#contact" class="btn primary-btn">Get Started</a>
              <a href="<?= $settings['youtube'] ?>" target="_blank"
                class="glightbox video-button">
                <span class="btn icon-btn rounded-full">
                  <i class="lni lni-youtube"></i>
                </span>
                <span class="text">Watch Videos</span>
              </a>
            </div>
          </div>
        </div>
        <div class="col-lg-6 col-md-12 col-12 order-1 order-md-2 mt-3">
  <div class="header-image">
    <div class="video-responsive">
      <img 
        src="./<?= getMedia($conn, 'Hero Image') ?>" 
        alt="Hero Image" 
        style="width: 100%; height: 100%; object-fit: cover;"
      />
    </div>
  </div>
</div>

      </div>
    </div>
  </section>
  <?php endif; ?>
<?php endforeach; ?>
  <style>
    .video-responsive {
        position: relative;
        width: 100%;
        /* 16:9 Aspect Ratio (9 / 16 = 0.5625) */
        padding-bottom: 63.25%; 
        height: 0;
        overflow: hidden;
      }

      .video-responsive img {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        border-radius:10px;
      }
  </style>
  <!-- End header Area -->
  
 <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Notice' && $section['visiblity'] == '1'): ?>

<?php

// Fetch active notices
$query = "SELECT * FROM notice WHERE deleted_at IS NULL AND status = 'Active' ORDER BY id DESC";
$result = $conn->query($query);
?>

<!-- Notice Marquee Section -->
<style>
.notice-bar {
  background: linear-gradient(90deg, #007BFF, #0056b3);
  color: #fff;
  padding: 10px 0;
  font-family: 'Segoe UI', sans-serif;
  font-size: 16px;
  font-weight: 500;
  position: relative;
  overflow: hidden;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2);
}

.notice-bar::before {
  content: "";
  font-weight: 600;
  color: #FFD700;
  margin-right: 15px;
  padding-left: 15px;
}

.notice-bar marquee {
  width: calc(100% - 100px);
}

.notice-text {
  display: inline-block;
  margin-right: 50px;
  background: rgba(255,255,255,0.15);
  padding: 5px 15px;
  border-radius: 20px;
  color: #fff;
  transition: background 0.3s ease;
}

.notice-text:hover {
  background: rgba(255,255,255,0.3);
}
</style>

<div class="notice-bar">
  <marquee behavior="scroll" direction="left" scrollamount="5" onmouseover="this.stop();" onmouseout="this.start();">
    <?php if ($result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
            <span class="notice-text">🔔 NOTICE : <?= htmlspecialchars($row['notice'] ?? $row['notice']); ?></span>
        <?php endwhile; ?>
    <?php else: ?>
        <span class="notice-text">No active notices available.</span>
    <?php endif; ?>
  </marquee>
</div>




  <?php endif; ?>
<?php endforeach; ?>


  <!--====== ABOUT FIVE PART START ======-->
 <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'About IKP' && $section['visiblity'] == '1'): ?>
  <section id="about" class="about-area about-five">
    <div class="container">
        <center><h2 class="fw-bold"><?php echo $section['title'] ?></h2></center><br>
      <div class="row align-items-center">
        <div class="col-lg-6 col-12">
          <div class="about-image-five">
            <svg class="shape" width="106" height="134" viewBox="0 0 106 134" fill="none"
              xmlns="http://www.w3.org/2000/svg">
              <circle cx="1.66654" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="16.3333" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="16.3333" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="16.3333" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="16.3333" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="30.9998" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="74.6665" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="30.9998" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="74.6665" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="30.9998" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="74.6665" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="30.9998" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="74.6665" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="60.3333" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="60.3333" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="60.3333" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="60.3333" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="132" r="1.66667" fill="#DADADA" />
            </svg>
            <img src="assets/images/about-img.jpg" alt="about" />
          </div>
        </div>
        <div class="col-lg-6 col-12">
          <div class="about-five-content">
            <h2 class="main-title fw-bold"><?= $settings['about_site'] ?></h2>
            <div class="about-five-tab">
              <nav>
                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                  <button class="nav-link active" id="nav-who-tab" data-bs-toggle="tab" data-bs-target="#nav-who"
                    type="button" role="tab" aria-controls="nav-who" aria-selected="true">Who We Are</button>
                  <button class="nav-link" id="nav-vision-tab" data-bs-toggle="tab" data-bs-target="#nav-vision"
                    type="button" role="tab" aria-controls="nav-vision" aria-selected="false">Vision & Mission</button>
                  <button class="nav-link" id="nav-history-tab" data-bs-toggle="tab" data-bs-target="#nav-history"
                    type="button" role="tab" aria-controls="nav-history" aria-selected="false">Philosophy</button>
                </div>
              </nav>
              <div class="tab-content" id="nav-tabContent">
                <div class="tab-pane fade show active" id="nav-who" role="tabpanel" aria-labelledby="nav-who-tab">
                  <?= getContent($conn,'Who we are') ?>
                  
                </div>
                <div class="tab-pane fade" id="nav-vision" role="tabpanel" aria-labelledby="nav-vision-tab">
                  <?= getContent($conn,'Vision & Mission') ?>
                </div>
                <div class="tab-pane fade" id="nav-history" role="tabpanel" aria-labelledby="nav-history-tab">
                  <?= getContent($conn,'Philosophy') ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- container -->
  </section>
    <?php endif; ?>
<?php endforeach; ?>
  <!--====== ABOUT FIVE PART ENDS ======-->

  <!-- ===== service-area start ===== -->
   <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Services' && $section['visiblity'] == '1'): ?>
  <section id="services" class="services-area services-eight">
    <!--======  Start Section Title Five ======-->
    <div class="section-title-five">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="content">  
              <h2 class="fw-bold"><?php echo $section['title'] ?></h2>
              <p width="100%">
           <?php echo $section['description'] ?>
              </p>
            </div>
          </div>
        </div>
        <!-- row -->
      </div>
      <!-- container -->
    </div>
    
<!-- ===== service-area start ===== -->
<section id="services" class="services-area pt-100 pb-70">
  <div class="container">
    <div class="row justify-content-center text-center">

      <?php
      // Fetch active services
      $serviceQuery = "SELECT title, description, image FROM services 
                       WHERE status = 'Active' 
                         AND deleted_at IS NULL 
                       ORDER BY created_at ASC";

      $serviceResult = mysqli_query($conn, $serviceQuery);

      if ($serviceResult && mysqli_num_rows($serviceResult) > 0):
        while ($service = mysqli_fetch_assoc($serviceResult)):
      ?>
        <div class="col-lg-4 col-md-6 mb-4">
          <div class="single-services p-4 h-100">
            
<?php if (!empty($service['image'])): ?>
  <div class="d-flex justify-content-center mb-3">
    <img src="./admin/<?= htmlspecialchars($service['image']) ?>" 
         alt="<?= htmlspecialchars($service['title']) ?>" 
         class="img-fluid" 
         style="max-height: 60px;">
  </div>
<?php endif; ?>


            <div class="service-content">
              <h4><?= htmlspecialchars($service['title']) ?></h4>
              <p><?= nl2br(htmlspecialchars($service['description'])) ?></p>
            </div>
          </div>
        </div>
      <?php
        endwhile;
      else:
      ?>
        <div class="col-12">
          <p class="text-center">No services available at the moment.</p>
        </div>
      <?php endif; ?>

    </div>
  </div>
</section>
   <?php endif; ?>
<?php endforeach; ?>
<!-- ===== service-area end ===== -->


<!-- Start Training Area -->
<?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Trainings' && $section['visiblity'] == '1'): ?>
<section id="trainings" class="pricing-area pricing-fourteen py-5">
  <div class="section-title-five">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="content text-center">
            <h2 class="fw-bold"><?php echo $section['title'] ?></h2>
            <p><?php echo $section['description'] ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="container">
    <div class="row justify-content-center">

      <?php
      // Fetch active courses from database
      $courseQuery = "SELECT name, description, image FROM course 
                      WHERE status = 'Active' 
                        AND deleted_at IS NULL 
                      ORDER BY created_at DESC";

      $courseResult = mysqli_query($conn, $courseQuery);

      if ($courseResult && mysqli_num_rows($courseResult) > 0):
        while ($course = mysqli_fetch_assoc($courseResult)):
      ?>

      <div class="col-lg-4 col-md-6 col-12 mb-4">
        <div class="pricing-style-fourteen h-100 d-flex flex-column">

          <!-- Optional image at top -->
          <?php if (!empty($course['image'])): ?>
            <img src="./admin/<?= htmlspecialchars($course['image']) ?>" alt="<?= htmlspecialchars($course['name']) ?>" class="img-fluid mb-3 rounded">
          <?php endif; ?>

          <!-- Course content -->
          <div class="table-head">
            <h6 class="title"><?= htmlspecialchars($course['name']) ?></h6>
            <p><?= nl2br(htmlspecialchars($course['description'])) ?></p>
          </div>

          <!-- Spacer to push button to bottom -->
          <div class="mt-auto pt-3">
            <a href="#contact" class="btn primary-btn-outline w-100">
              Get Started
            </a>
          </div>

        </div>
      </div>

      <?php 
        endwhile;
      else:
      ?>
        <div class="col-12 text-center">
          <p>No training programs available at the moment.</p>
        </div>
      <?php endif; ?>

    </div>
  </div>
</section>
 <?php endif; ?>
<?php endforeach; ?>
<!--/ End Training Area -->

  <!-- Start Cta Area -->
  <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'CTA' && $section['visiblity'] == '1'): ?>
  <section id="call-action" class="call-action">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xxl-6 col-xl-7 col-lg-8 col-md-9">
          <div class="inner-content">
            <h2><?= getContent($conn,'Cta Title') ?></h2>
            <?= getContent($conn,'Cta Description') ?>
            <div class="light-rounded-buttons">
              <a href="#contact" class="btn primary-btn-outline">Get Started</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <?php endif; ?>
<?php endforeach; ?>
  <!-- End Cta Area -->
  
   <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Testimonials' && $section['visiblity'] == '1'): ?> 
<section id="testimonials" class="testimonials py-5 bg-light">
  <div class="container">
    <h2 class="text-center mb-5"><?php echo $section['title'] ?></h2>

    <?php
    // Fetch only active text testimonials
    $query = "SELECT testimonial_id, name, review 
              FROM testimonials 
              WHERE status = 'Active' 
                AND type = 'Text' 
                AND deleted_at IS NULL 
              ORDER BY created_at DESC";

    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0): 
      $testimonials = mysqli_fetch_all($result, MYSQLI_ASSOC);
    ?>

    <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="4000">
      
      <!-- Carousel Items -->
      <div class="carousel-inner">
        <?php foreach ($testimonials as $index => $testimonial): ?>
          <div class="carousel-item text-center <?= $index === 0 ? 'active' : '' ?>">
            <p class="lead">“<?= htmlspecialchars($testimonial['review']) ?>”</p>
            <h5>- <?= htmlspecialchars($testimonial['name']) ?></h5>
          </div>
        <?php endforeach; ?>
      </div>

      <!-- Carousel Indicators -->
      <div class="carousel-indicators">
        <?php foreach ($testimonials as $index => $_): ?>
          <button 
            type="button" 
            data-bs-target="#testimonialCarousel" 
            data-bs-slide-to="<?= $index ?>" 
            class="<?= $index === 0 ? 'active' : '' ?>" 
            aria-current="<?= $index === 0 ? 'true' : 'false' ?>" 
            aria-label="Slide <?= $index + 1 ?>">
          </button>
        <?php endforeach; ?>
      </div>

      <!-- Carousel Controls -->
      <button class="carousel-control-prev" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
      </button>

    </div>

    <?php else: ?>
      <p class="text-center">No text testimonials available at the moment.</p>
    <?php endif; ?>
<!--  </div>-->
<!--</section>-->

<!--<section id="video-testimonials" class="testimonials py-5 bg-light">-->
<!--  <div class="container">-->
<!--    <h2 class="text-center mb-5">What IKP'ans Share in Videos</h2>-->

    <?php
    // Fetch only active video testimonials
    $videoQuery = "SELECT testimonial_id, name, review 
                   FROM testimonials 
                   WHERE status = 'active' 
                     AND type = 'Video' 
                     AND deleted_at IS NULL 
                   ORDER BY created_at DESC";

    $videoResult = mysqli_query($conn, $videoQuery);

    if ($videoResult && mysqli_num_rows($videoResult) > 0): 
      $videos = mysqli_fetch_all($videoResult, MYSQLI_ASSOC);
    ?>

    <div class="row justify-content-center mt-5">
      <?php foreach ($videos as $video): ?>
        <div class="col-lg-3 col-md-4 mb-4">
          <div class="card shadow-sm">
            <div class="ratio ratio-16x9">
              <iframe 
                src="<?= htmlspecialchars($video['review']) ?>" 
                title="Video Testimonial by <?= htmlspecialchars($video['name']) ?>" 
                frameborder="0" 
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                allowfullscreen>
              </iframe>
            </div>
            <div class="card-body text-center">
              <h5 class="card-title mb-0"><?= htmlspecialchars($video['name']) ?></h5>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <?php else: ?>
      <p class="text-center">No video testimonials available at the moment.</p>
    <?php endif; ?>
  </div>
</section>
  <?php endif; ?>
<?php endforeach; ?>


<!--Faq section-->
   <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'FAQ' && $section['visiblity'] == '1'): ?>
<section id="faq" class="faq-area py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-12">
        <h2 class="text-center mb-4"><?php echo $section['title']; ?></h2>

        <?php
        // Fetch active FAQs from the database
        $faqQuery = "SELECT faq_id, question, answer FROM faq 
                     WHERE status = 'Active' 
                       AND deleted_at IS NULL 
                     ORDER BY created_at ASC";

        $faqResult = mysqli_query($conn, $faqQuery);
         $sl=1;
        if ($faqResult && mysqli_num_rows($faqResult) > 0): 
          $faqs = mysqli_fetch_all($faqResult, MYSQLI_ASSOC);
        ?>

        <div class="accordion" id="faqAccordion">
          <?php foreach ($faqs as $index => $faq): 
            $faqId = 'faq' . $faq['faq_id'];
            $collapseId = 'collapse' . $faq['faq_id'];
            $isFirst = $index === 0;
          ?>
            <div class="accordion-item">
              <h2 class="accordion-header" id="<?= $faqId ?>">
                <button class="accordion-button <?= !$isFirst ? 'collapsed' : '' ?>" 
                        type="button" 
                        data-bs-toggle="collapse" 
                        data-bs-target="#<?= $collapseId ?>" 
                        aria-expanded="<?= $isFirst ? 'true' : 'false' ?>" 
                        aria-controls="<?= $collapseId ?>">
                   <?= $sl ?>. &nbsp;<?= $faq['question'] ?>
                </button>
              </h2>
              <div id="<?= $collapseId ?>" 
                   class="accordion-collapse collapse <?= $isFirst ? 'show' : '' ?>" 
                   aria-labelledby="<?= $faqId ?>" 
                   data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                  <?= $faq['answer'] ?>
                </div>
              </div>
            </div>
          <?php $sl++; endforeach; ?>
        </div>

        <?php else: ?>
          <p class="text-center">No FAQs available at the moment.</p>
        <?php endif; ?>
        
      </div>
    </div>
  </div>
</section>
  <?php endif; ?>
<?php endforeach; ?>
<!-- ========================= contact-section start ========================= -->
<?php
// Fetch subjects and references from the database before rendering the form
$query_subjects = "SELECT * FROM enquiries_subjects";
$result_subjects = mysqli_query($conn, $query_subjects);

?>
  <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Contact' && $section['visiblity'] == '1'): ?>
<section id="contact" class="contact-section">
  <div class="container">
    <div class="row">
      <div class="col-xl-12">
        <div class="contact-form-wrapper">
          <div class="row">
            <div class="col-xl-10 col-lg-8 mx-auto">
              <div class="section-title text-center">
                <h2><?php echo $section['title']; ?></h2>
                <p><?php echo $section['description']; ?></p>
              </div>
            </div>
          </div>
          <!-- Form for Enquiry -->
          <form id="enquiry-form" class="contact-form">
            <div class="row">
              <div class="col-md-6">
                <input type="text" name="name" id="name" placeholder="Name" required />
              </div>
              <div class="col-md-6">
                <input type="email" name="email" id="email" placeholder="Email" required />
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <input type="text" name="phone" id="phone" placeholder="Phone" required />
              </div>
              <div class="col-md-6">
                <select name="subject" id="subject" class="form-select" >
                  <option value="">Select Subject</option>
                  <?php while ($row_subject = mysqli_fetch_assoc($result_subjects)) { ?>
                    <option value="<?php echo $row_subject['id']; ?>">
                      <?php echo htmlspecialchars($row_subject['subjects']); ?>
                    </option>
                  <?php } ?>
                </select>
              </div>
              <input type="hidden" id="reference" name="reference" value="">

            </div>
            <div class="row">
              <div class="col-12">
                <textarea name="message" id="message" placeholder="Type your message" rows="5" required></textarea>
              </div>
            </div>
            <div class="row">
                <input type="hidden" name="source" id="source" value="Online" />
            </div>
            <div class="row">
              <div class="col-12">
                <div class="button text-center rounded-buttons">
                  <button type="button" id="submit-btn" class="btn primary-btn rounded-full">
                    Send Enquiry
                  </button>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>
 <?php endif; ?>
<?php endforeach; ?>
<!-- ========================= contact-section end ========================= -->


  <!-- Start Footer Area -->
  <footer class="footer-area footer-eleven">
    <!-- Start Footer Top -->
    <div class="footer-top">
      <div class="container">
        <div class="inner-content">
          <div class="row">
            <div class="col-lg-6 col-md-6 col-12">
              <!-- Single Widget -->
              <div class="footer-widget f-about">
                <div class="logo">
                  <a href="index.html">
                    <img src="<?= $settings['logo'] ?>" width="220px" alt="#" class="img-fluid" />
                  </a>
                </div>
                <p>
                  <?= $settings['about_site'] ?>
                </p>
                
                <!-- Start Social Links -->
                <div class="social-links " style="margin-top: 20px;">
                <a href="<?= $settings['youtube'] ?>" target="_blank"><i class="lni lni-youtube"></i></a>
                <a href="<?= $settings['facebook'] ?>" target="_blank"><i class="lni lni-facebook-filled"></i></a>
                <a href="<?= $settings['instagram'] ?>" target="_blank"><i class="lni lni-instagram-original"></i></a>
                <a href="<?= $settings['x'] ?>" target="_blank"><i class="lni lni-twitter-original"></i></a>
                <a href="<?= $settings['linkedin'] ?>" target="_blank"><i class="lni lni-linkedin-original"></i></a>
              </div>

                <!-- End Social Links -->

                <style>
                .social-links a {
                    display: inline-block;
                    margin: 0 10px;
                    font-size: 24px;
                    color: #333; /* icon color */
                    transition: color 0.3s;
                  }

                  .social-links a:hover {
                    color: #007bff; /* color on hover */
                  }

                </style>

              </div>
              <!-- End Single Widget -->
            </div>
            <div class="col-lg-2 col-md-6 col-12">
              <!-- Single Widget -->
              <div class="footer-widget f-link">
                <h5>Navigation</h5>
                <ul>
  <?php foreach ($sections as $section): ?>
    <?php
      // Skip if not visible in footer or if it's the Hero-Home section
      if ($section['footer_visibility'] != '1' || $section['title'] === 'Hero-Home') {
        continue;
      }

      $label = htmlspecialchars($section['name']);

      // Handle special href cases
      switch ($section['name']) {
        case 'About IKP':
          $href = '#about';
          break;
        default:
          $href = '#' . strtolower(str_replace(' ', '', $section['name']));
          break;
      }
    ?>
    <li><a href="<?= $href ?>"><?= $label ?></a></li>
  <?php endforeach; ?>
</ul>

              </div>
              <!-- End Single Widget -->
            </div>
            
            <div class="col-lg-4 col-md-6 col-12">
              <!-- Single Widget -->
              <div class="footer-widget f-link">
                <h5>Contact</h5>
                <ul>
  <?php if (!empty($settings['address'])): ?>
    <li><i class="lni lni-pin"></i> <?= htmlspecialchars($settings['address']) ?></li>
  <?php endif; ?>

  <?php if (!empty($settings['phone'])): ?>
    <li><i class="lni lni-phone"></i> <?= htmlspecialchars($settings['phone']) ?></li>
  <?php endif; ?>

  <?php if (!empty($settings['email'])): ?>
    <li><i class="lni lni-envelope"></i> <?= htmlspecialchars($settings['email']) ?></li>
  <?php endif; ?>
</ul>

                    
                  </div>
              </div>
              <!-- End Single Widget -->
            </div>
          </div>
        </div>
      </div>

    <!--/ End Footer Top -->
    <br><br> <hr>   
    <p class="copyright-text text-center">
      <span>© <?php echo date("Y"); ?> <?= $settings['site_name'] ?>.</span>Designed by
      <a href="<?= $settings['developer_website'] ?>">  <?= $settings['developer'] ?></a>
    </p>
  </footer>
  <!--/ End Footer Area -->

	<!-- WhatsApp Floating Button -->
<a href="https://wa.me/91<?= $settings['whatsapp'] ?>?text=Hii <?= $settings['site_name'] ?>" target="_blank" class="whatsapp-button">
  <i class="lni lni-whatsapp"></i> Chat with us
</a>

<!-- CSS -->
<style>
.whatsapp-button {
  position: fixed;
  bottom: 20px;
  left: 20px; /* changed from right to left */
  background-color: #25D366;
  color: #fff;
  padding: 12px 18px;
  border-radius: 50px;
  font-size: 16px;
  text-decoration: none;
  display: flex;
  align-items: center;
  gap: 8px;
  box-shadow: 0 4px 6px rgba(0,0,0,0.2);
  z-index: 9999;
  transition: transform 0.2s, box-shadow 0.2s;
}

.whatsapp-button:hover {
  transform: scale(1.1);
  box-shadow: 0 6px 12px rgba(0,0,0,0.3);
}

.whatsapp-button i {
  font-size: 24px;
}
</style>


  <a href="#" class="scroll-top btn-hover">
    <i class="lni lni-chevron-up"></i>
  </a>

  <!--====== js ======-->
  <script src="assets/js/bootstrap.bundle.min.js"></script>
  <script src="assets/js/glightbox.min.js"></script>
  <script src="assets/js/main.js"></script>
  <script src="assets/js/tiny-slider.js"></script>
  <?= $settings['footer_scripts'] ?>


  <script>

    //===== close navbar-collapse when a  clicked
    let navbarTogglerNine = document.querySelector(
      ".navbar-nine .navbar-toggler"
    );
    navbarTogglerNine.addEventListener("click", function () {
      navbarTogglerNine.classList.toggle("active");
    });

    // ==== left sidebar toggle
    let sidebarLeft = document.querySelector(".sidebar-left");
    let overlayLeft = document.querySelector(".overlay-left");
    let sidebarClose = document.querySelector(".sidebar-close .close");

    overlayLeft.addEventListener("click", function () {
      sidebarLeft.classList.toggle("open");
      overlayLeft.classList.toggle("open");
    });
    sidebarClose.addEventListener("click", function () {
      sidebarLeft.classList.remove("open");
      overlayLeft.classList.remove("open");
    });

    // ===== navbar nine sideMenu
    let sideMenuLeftNine = document.querySelector(".navbar-nine .menu-bar");

    sideMenuLeftNine.addEventListener("click", function () {
      sidebarLeft.classList.add("open");
      overlayLeft.classList.add("open");
    });

    //========= glightbox
    GLightbox({
      'href': 'https://www.youtube.com/watch?v=r44RKWyfcFw&fbclid=IwAR21beSJORalzmzokxDRcGfkZA1AtRTE__l5N4r09HcGS5Y6vOluyouM9EM',
      'type': 'video',
      'source': 'youtube', //vimeo, youtube or local
      'width': 900,
      'autoplayVideos': true,
    });

  </script>
<script>
// JavaScript for form validation and sending the data via AJAX

document.getElementById('submit-btn').addEventListener('click', function(event) {
    event.preventDefault(); // Prevent form submission

    // Get form values
    let name = document.getElementById('name').value;
    let email = document.getElementById('email').value;
    let phone = document.getElementById('phone').value;
    let subject = document.getElementById('subject').value;
    let reference = document.getElementById('reference').value;
    let message = document.getElementById('message').value;
    let source = document.getElementById('source').value;

    // Validate the phone number (only digits)
    let phoneRegex = /^[0-9]{10}$/;
    if (!phoneRegex.test(phone)) {
        alert("Please enter a valid 10-digit phone number.");
        return;
    }

    // Validate the email format
    let emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email)) {
        alert("Please enter a valid email address.");
        return;
    }

    // Remove non-alphanumeric characters and spaces from the name
    name = name.replace(/[^a-zA-Z0-9 ]/g, '');

    // Create a JSON object with form data
    let formData = {
        name: name,
        email: email,
        phone: phone,
        subject: subject,
        reference: reference,
        message: message,
        source: source
    };

    // Send data via AJAX using Fetch API
    fetch('submit-enquiry.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(formData),
    })
    .then(response => response.text())  // Fetch response as plain text
.then(responseText => {
    console.log('Raw response:', responseText);  // Log the raw response
    try {
        let data = JSON.parse(responseText);  // Try parsing it as JSON
        if (data.success) {
            alert('Enquiry submitted successfully! We will contact shortly!');
        } else {
            alert('Error: ' + data.message);
        }
    } catch (error) {
        console.error('Failed to parse JSON:', error);
        alert('Something went wrong, please try again later.');
    }
})

    .catch((error) => {
        console.error('Error:', error);
        alert('Something went wrong, please try again later.');
    });
});
</script>

</body>
</html>
<?php $conn->close(); ?>