<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include_once('config.php');
// Enable error reporting for debugging

header('Access-Control-Allow-Origin: *');  // Allow all origins (adjust as necessary for security)
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');


// Get the JSON data sent by the client
$data = json_decode(file_get_contents('php://input'), true);

// Sanitize the input data
$name = filter_var($data['name'], FILTER_SANITIZE_STRING);
$email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
$phone = filter_var($data['phone'], FILTER_SANITIZE_NUMBER_INT);
$subject = filter_var($data['subject'], FILTER_SANITIZE_NUMBER_INT);
$reference = filter_var($data['reference'], FILTER_SANITIZE_NUMBER_INT);
$message = filter_var($data['message'], FILTER_SANITIZE_STRING);
$source = filter_var($data['source'], FILTER_SANITIZE_STRING);

// Validate the sanitized email and phone (again as a fallback)
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid email format.']);
    exit;
}

if (!preg_match("/^[0-9]{10}$/", $phone)) {
    echo json_encode(['success' => false, 'message' => 'Phone number must be 10 digits.']);
    exit;
}

$sql = "INSERT INTO enquiries (name, email, phone, subject, reference, message, source) 
        VALUES ('$name', '$email', '$phone', '$subject', '$reference', '$message', '$source')";

if (mysqli_query($conn, $sql)) {
    echo json_encode(['success' => true, 'message' => 'Enquiry submitted successfully.']);
} else {
    $error = mysqli_error($conn);
    echo json_encode(['success' => false, 'message' => 'Database insertion failed: ' . $error]);
}


mysqli_close($conn);
?>
